/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.cache.file;

import com.manatee.common.util.tool.cache.Cache;
import com.manatee.common.util.tool.cache.file.AbstractFileCache;
import com.manatee.common.util.tool.cache.impl.LFUCache;
import java.io.File;

public class LFUFileCache
extends AbstractFileCache {
    private static final long serialVersionUID = 1L;

    public LFUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LFUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LFUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        return new LFUCache<File, byte[]>(this.capacity, this.timeout){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isFull() {
                return LFUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LFUFileCache.this.usedSize -= cachedObject.length;
            }
        };
    }
}

