/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.net.multipart;

import com.manatee.common.util.net.multipart.UploadFileHeader;
import com.manatee.common.util.net.multipart.UploadSetting;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class UploadFile {
    private static final String TMP_FILE_PREFIX = "manatee-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private final UploadFileHeader header;
    private final UploadSetting setting;
    private long size = -1L;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader header, UploadSetting setting) {
        this.header = header;
        this.setting = setting;
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public InputStream getFileInputStream() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.data));
        }
        if (this.tempFile != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    public long size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0L;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    private void assertValid() throws IOException {
        if (!this.isUploaded()) {
            throw new IOException(StrUtil.format("File [{}] upload fail", this.getFileName()));
        }
    }
}

