/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.util.Ariths;
import com.manatee.common.util.StrUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberUtils
extends org.apache.commons.lang.math.NumberUtils {
    public static int doubleToInt(double value) {
        return new Double(value).intValue();
    }

    public static int parseInt(Object str) {
        String s = StrUtils.GetString(str);
        int result = 0;
        if (!s.equals("")) {
            result = Integer.parseInt(s);
        }
        return result;
    }

    public static long parseLong(Object str) {
        String s = StrUtils.GetString(str);
        long result = 0L;
        if (!s.equals("")) {
            result = Long.parseLong(s);
        }
        return result;
    }

    public static float parseFloat(Object str) {
        String s = StrUtils.GetString(str);
        float result = 0.0f;
        if (!s.equals("")) {
            result = Float.parseFloat(s);
        }
        return result;
    }

    public static double parseDouble(Object str) {
        String s = StrUtils.GetString(str);
        double result = 0.0;
        if (!s.equals("")) {
            result = Double.parseDouble(s);
        }
        return result;
    }

    public static String formatNumber(double value, int digitNum) {
        String str = "0.000";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < digitNum; ++i) {
            sb.append("0");
        }
        DecimalFormat nf = new DecimalFormat("#0." + sb.toString());
        nf.setParseIntegerOnly(false);
        nf.setDecimalSeparatorAlwaysShown(false);
        str = nf.format(value);
        if (StrUtils.isEmpty((String)str.split("\\.")[0])) {
            str = "0" + str;
        }
        return str;
    }

    public static String formatNumber(String code, int num) {
        String result = String.format("%0" + num + "d", Integer.parseInt(code));
        return result;
    }

    public static double formatDouble(double value, int digitNum) {
        BigDecimal doublevalue = new BigDecimal(value);
        return doublevalue.setScale(digitNum, 4).doubleValue();
    }

    public static String numUnitConver(double num) {
        DecimalFormat df = new DecimalFormat("#0.00");
        return NumberUtils.numFormat(num, df);
    }

    public static String numUnitConver(String text, int scale) {
        DecimalFormat df = NumberUtils.getDecimalFormat(scale);
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return NumberUtils.numFormat(number, df);
    }

    public static String formatMicrometer(String text, int scale) {
        DecimalFormat df = NumberUtils.getDecimalFormat(scale);
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    private static DecimalFormat getDecimalFormat(int scale) {
        StringBuilder sb = new StringBuilder("###,##0");
        for (int i = 1; i <= scale; ++i) {
            if (i == 1) {
                sb.append(".");
            }
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        return df;
    }

    private static String numFormat(double num, DecimalFormat df) {
        if (num >= 1.0E12 || num <= -1.0E12) {
            num = Ariths.div(num, 1.0E12);
            return df.format(num) + "\u4e07\u4ebf";
        }
        if (num >= 1.0E8 || num <= -1.0E8) {
            num = Ariths.div(num, 1.0E8);
            return df.format(num) + "\u4ebf";
        }
        if (num >= 10000.0 || num <= -10000.0) {
            num = Ariths.div(num, 10000.0);
            return df.format(num) + "\u4e07";
        }
        return df.format(num);
    }

    public static boolean isNumericType(String str) {
        try {
            new BigDecimal(str);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isNumeric(String str) {
        try {
            Double.valueOf(str);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isIntegralNumber(String str) {
        Pattern pattern = Pattern.compile("^[0-9]*$");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static Object formatNum(BigDecimal value) {
        if (new BigDecimal(value.intValue()).compareTo(value) == 0) {
            return value.intValue();
        }
        return value.doubleValue();
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static void main(String[] arg) {
        String c = "c0";
        Boolean re = NumberUtils.isNumericType(c);
        System.out.println(re + "");
    }
}

