/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultBO;
import com.manatee.common.domain.ResultTrace;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.domain.WebResult;
import com.manatee.lowcode.manager.ResultMsgManager;
import com.manatee.process.domain.Debug;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Warn;
import com.manatee.process.util.ErrorTraceUtil;
import com.manatee.process.util.UnBlockErrorUtil;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WebUtil {
    @Value(value="${manatee.webResult.convert:false}")
    private Boolean resultConvert;
    @Resource
    private ResultMsgManager resultMsgManager;

    public ModularityResult wirteLowcodeResult(ProcessContent content) {
        ModularityResult result = new ModularityResult();
        Map data = content.getResponse();
        data.put("traceId", content.getTraceId());
        result.setData(data);
        ResultTrace resultTrace = content.getErrorTrace().getResultTrace();
        result.setCode(resultTrace.getCode());
        result.setSubCode(resultTrace.getSubCode());
        String msg = this.resultMsgManager.getMsg(content);
        result.setMsg(msg);
        if (resultTrace.getId() >= 0) {
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
        }
        return result;
    }

    public JSONObject wirteLowcodeResultJson(ProcessContent content) {
        WebResult result = this.wirteToResult(content);
        return result.toJson();
    }

    public WebResult wirteToResult(ProcessContent content) {
        WebResult result = WebUtil.wirteResult(content);
        result.setResultConvert(this.resultConvert);
        String msg = this.resultMsgManager.getMsg(content);
        ResultTrace resultTrace = content.getErrorTrace().getResultTrace();
        resultTrace.setMsg(msg);
        Integer status = (Integer)content.getRequestSubValue("outputStatus");
        if (status != null) {
            resultTrace.setResultStatus(status);
        }
        result.setResultTrace(resultTrace);
        return result;
    }

    public static WebResult wirteResult(ProcessContent content) {
        JSONArray unBlockErrors;
        JSONArray trace;
        JSONObject backStructure;
        WebResult result = new WebResult();
        ResultTrace resultTrace = content.getErrorTrace().getResultTrace();
        result.setResultTrace(resultTrace);
        JSONObject projectConf = content.getProjectConf();
        if (projectConf != null && (backStructure = projectConf.getJSONObject("backStructure")) != null) {
            result.setBackStructure(backStructure);
        }
        if (content.getResponse() != null) {
            result.setData(content.getResponse());
        }
        if (content.getDebug() != null) {
            Debug debug = content.getDebug();
            JSONObject debugJson = debug.getResult();
            Warn warn = content.getWarn();
            if (warn != null) {
                result.setWarn(warn.getResult());
            }
            result.setDebug(debugJson);
            result.setRequest(content.getRequest());
        }
        if (content.getRequest() != null) {
            Integer status;
            String msg = (String)content.getRequestSubValue("outputMsg");
            if (StringUtil.isNotBlank((String)msg)) {
                resultTrace.setMsg(msg);
            }
            if ((status = (Integer)content.getRequestSubValue("outputStatus")) != null) {
                resultTrace.setResultStatus(status);
            }
        }
        if ((trace = ErrorTraceUtil.getErrorTraces((ProcessContent)content)).size() > 0) {
            result.setErrorTrace(trace);
        }
        if (CollectionUtils.isNotEmpty((Collection)(unBlockErrors = UnBlockErrorUtil.getUnBlockErrors((ProcessContent)content)))) {
            result.setUnBlockError(unBlockErrors);
        }
        resultTrace.setTraceId(content.getTraceId());
        return result;
    }

    public static WebResult wirteResult(ResultBO<JSONObject> resultBO) {
        WebResult result = new WebResult();
        if (resultBO.isSuccess() && resultBO.getModel() != null) {
            result.setData((Map)resultBO.getModel());
        }
        result.setResultTrace(resultBO.getResultTrace());
        return result;
    }

    public static void setHeaderAllowOrigin(HttpServletResponse response, String domain) {
        if (domain == null) {
            domain = "*";
        }
        response.addHeader("Access-Control-Allow-Origin", domain);
        response.addHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS");
        response.addHeader("Access-Control-Allow-Headers", "Content-type,hello");
        response.addHeader("Access-Control-Max-Age", "50");
    }

    public static boolean isSuccessResult(WebResult result) {
        return result != null && result.isSuccess() && result.getData() != null;
    }

    public static boolean haveData(WebResult result) {
        return result != null && result.getData() != null;
    }
}

