/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.store.handle;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.FileUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.ProcessFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManateeFileHandle {
    private static Logger LOGGER = LoggerFactory.getLogger(ManateeFileHandle.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    public void getContentFiles(ProcessContent content, String fileSource, Boolean needDel, Boolean autoCover, List<ProcessFileInfo> fileInfos, boolean notAllowNullFile) throws BizException {
        LOGGER.info("getContentFiles, fileSource:{}, needDel:{}, autoCover:{}, notAllowNullFile:{}", new Object[]{fileSource, needDel, autoCover, notAllowNullFile});
        if (StringUtil.isBlank((String)fileSource) || "local".equals(fileSource)) {
            String[] split;
            this.processConfUtil.checkConf(content, new String[]{"fileList"});
            String fileListStr = this.variableUtil.calVarInConf(content, "fileList");
            for (String filePath : split = fileListStr.split(StrSplit.FH)) {
                File file = new File(filePath);
                ProcessFileInfo info = new ProcessFileInfo();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    info.setFileName(FileUtil.getNewFileName((Boolean)autoCover, (String)file.getName()));
                    info.setNeedDel(needDel == null ? Boolean.FALSE : needDel);
                    info.setInputStream((InputStream)fileInputStream);
                    info.setFile(file);
                    fileInfos.add(info);
                }
                catch (FileNotFoundException e) {
                    throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
                }
            }
        } else {
            InputStream file = content.getFile();
            String fileName = content.getFileName();
            if (file != null) {
                if (StringUtil.isBlank((String)fileName)) {
                    fileName = UUID.randomUUID().toString();
                }
                ProcessFileInfo info = new ProcessFileInfo();
                info.setInputStream(content.getFile());
                info.setNeedDel(Boolean.FALSE);
                info.setFileName(FileUtil.getNewFileName((Boolean)autoCover, (String)content.getFileName()));
                fileInfos.add(info);
            }
            if (content.getFiles() != null) {
                fileInfos.addAll(content.getFiles());
            }
        }
        if ((fileInfos == null || fileInfos.size() <= 0) && notAllowNullFile) {
            throw new BizException(ResultCode.CONF_ERROR, "\u5f85\u4e0a\u4f20\u7684\u6587\u4ef6\u4e3a\u7a7a");
        }
    }

    public void getContentFiles(ProcessContent content, String fileSource, Boolean needDel, Boolean autoCover, List<ProcessFileInfo> fileInfos) throws BizException {
        this.getContentFiles(content, fileSource, needDel, autoCover, fileInfos, false);
    }
}

