/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.config;

import com.manatee.common.util.StringUtil;
import com.manatee.config.ManateeConfig;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="manateeElasticSearchConfigDefault")
public class ManateeElasticSearchConfig {
    @Resource
    private ManateeConfig manateeConfig;

    @Bean(value={"restHighLevelClientDefault"})
    public RestHighLevelClient restHighLevelClient() {
        RestClientBuilder restClientBuilder;
        HttpHost[] httpHosts;
        String clusterNodes = this.manateeConfig.getElasticsearch().getClusterNodes();
        String username = this.manateeConfig.getElasticsearch().getUsername();
        String password = this.manateeConfig.getElasticsearch().getPassword();
        if (StringUtil.isNotBlank((String)clusterNodes)) {
            String[] nodes = clusterNodes.split(",");
            httpHosts = new HttpHost[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                String node = nodes[i];
                String[] split = node.split(":");
                httpHosts[i] = new HttpHost(split[0], Integer.valueOf(split[1]).intValue(), "http");
            }
        } else {
            httpHosts = new HttpHost[]{new HttpHost("xx.xx.xx.xx", 0, "http")};
        }
        if (StringUtil.isNotBlank((String)username) && StringUtil.isNotBlank((String)password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            restClientBuilder = RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(arg_0 -> ManateeElasticSearchConfig.lambda$restHighLevelClient$0((CredentialsProvider)credentialsProvider, arg_0));
        } else {
            restClientBuilder = RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(requestConfig -> requestConfig.setKeepAliveStrategy((response, context) -> TimeUnit.MINUTES.toMillis(1L)));
        }
        return new RestHighLevelClient(restClientBuilder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restHighLevelClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

