/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mtop.filter;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.mtop.filter.MtopFilterBase;
import com.manatee.mtop.filter.handle.IHandle;
import com.manatee.mtop.filter.handle.domain.MtopContext;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;

@WebFilter(filterName="mtopFilter", urlPatterns={"/*"}, asyncSupported=true)
public class MtopFilter
extends MtopFilterBase {
    private String handles = "session,probation";

    public MtopFilter(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        MtopContext context = new MtopContext();
        try {
            context.setRequest(request);
            String[] handleStrs = this.handles.split(",");
            for (int i = 0; i < handleStrs.length; ++i) {
                IHandle handle = (IHandle)this.handleMap.get(handleStrs[i]);
                if (handle == null) continue;
                handle.doHandle(context);
            }
        }
        catch (BizException e) {
            if (ResultCode.NOT_AUTHORIZED.getCode().equals(e.getCode())) {
                response.sendError(401, e.getMessage());
            } else if (ResultCode.NO_LICENSE.getCode().equals(e.getCode()) || ResultCode.NOT_COMMERCIAL_VERSION.getCode().equals(e.getCode())) {
                response.sendError(452, e.getMessage());
            } else {
                response.sendError(403, e.getMessage());
            }
            return;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String traceId = request.getParameter("traceId");
        if (StringUtil.isBlank((String)traceId)) {
            traceId = UUID.randomUUID().toString();
            request.setAttribute("traceId", (Object)traceId);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

