/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.tool.core.collection.ArrayIter;
import com.manatee.common.util.tool.core.lang.func.Func1;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.handler.RsHandler;
import com.manatee.lowcodedb.newdb.sql.NamedSql;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class SqlExecutor {
    public static int execute(Connection conn, String sql, Map<String, Object> paramMap) throws SQLException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.execute(conn, namedSql.getSql(), namedSql.getParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(Connection conn, String sql, Object ... params) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(false, conn, sql, params);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean call(Connection conn, String sql, Object ... params) throws SQLException {
        boolean bl;
        CallableStatement call = null;
        try {
            call = StatementUtil.prepareCall(conn, sql, params);
            bl = call.execute();
        }
        catch (Throwable throwable) {
            DbUtil.close(call);
            throw throwable;
        }
        DbUtil.close(call);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> JSON executeCall(Connection conn, String sql, RsHandler<T> rsh, Map<Integer, Map<String, Object>> outParams, Object ... params) throws SQLException {
        CallableStatement call;
        block5: {
            JSONObject jSONObject;
            call = null;
            try {
                call = StatementUtil.prepareCall(conn, sql, outParams, params);
                call.execute();
                if (outParams == null || outParams.size() <= 0) break block5;
                JSONObject resultJson = new JSONObject();
                for (Map.Entry<Integer, Map<String, Object>> entry : outParams.entrySet()) {
                    Integer key = entry.getKey();
                    Map<String, Object> value = entry.getValue();
                    Object resultObj = call.getObject(key);
                    if (resultObj instanceof ResultSet) {
                        T resultHandle = rsh.handle((ResultSet)resultObj);
                        resultJson.put(value.get("keyName").toString(), resultHandle);
                        continue;
                    }
                    resultJson.put(value.get("keyName").toString(), resultObj);
                }
                jSONObject = resultJson;
            }
            catch (Throwable throwable) {
                DbUtil.close(call);
                throw throwable;
            }
            DbUtil.close(call);
            return jSONObject;
        }
        JSON jSON = null;
        DbUtil.close(call);
        return jSON;
    }

    public static ResultSet callQuery(Connection conn, String sql, Object ... params) throws SQLException {
        return StatementUtil.prepareCall(conn, sql, params).executeQuery();
    }

    public static Long executeForGeneratedKey(Connection conn, String sql, Map<String, Object> paramMap) throws SQLException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.executeForGeneratedKey(conn, namedSql.getSql(), namedSql.getParams());
    }

    /*
     * Exception decompiling
     */
    public static Long executeForGeneratedKey(Connection conn, String sql, Object ... params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public static int[] executeBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        return SqlExecutor.executeBatch(conn, sql, (Iterable<Object[]>)new ArrayIter((Object)paramsBatch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        int[] nArray;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatementForBatch(conn, sql, paramsBatch);
            nArray = ps.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return nArray;
    }

    public static int[] executeBatch(Connection conn, String ... sqls) throws SQLException {
        return SqlExecutor.executeBatch(conn, (Iterable<String>)new ArrayIter((Object)sqls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection conn, Iterable<String> sqls) throws SQLException {
        Object object;
        Statement statement = null;
        try {
            statement = conn.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            object = statement.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(statement);
            throw throwable;
        }
        DbUtil.close(statement);
        return object;
    }

    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws SQLException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.query(conn, namedSql.getSql(), rsh, namedSql.getParams());
    }

    public static <T> T query(Connection conn, SqlBuilder sqlBuilder, RsHandler<T> rsh) throws SQLException {
        return SqlExecutor.query(conn, sqlBuilder.build(), rsh, sqlBuilder.getParamValueArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(false, conn, sql, params);
            t = SqlExecutor.executeQuery(ps, rsh);
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return t;
    }

    public static <T> T query(Connection conn, Func1<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws SQLException {
        T t;
        PreparedStatement ps = null;
        try {
            ps = (PreparedStatement)statementFunc.call((Object)conn);
            t = SqlExecutor.executeQuery(ps, rsh);
        }
        catch (Exception e) {
            try {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return t;
    }

    public static int executeUpdate(PreparedStatement ps, Object ... params) throws SQLException {
        StatementUtil.fillParams(ps, params);
        return ps.executeUpdate();
    }

    public static boolean execute(PreparedStatement ps, Object ... params) throws SQLException {
        StatementUtil.fillParams(ps, params);
        return ps.execute();
    }

    public static <T> T query(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws SQLException {
        StatementUtil.fillParams(ps, params);
        return SqlExecutor.executeQuery(ps, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T queryAndClosePs(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t;
        try {
            t = SqlExecutor.query(ps, rsh, params);
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeQuery(PreparedStatement ps, RsHandler<T> rsh) throws SQLException {
        T t;
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            t = rsh.handle(rs);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            throw throwable;
        }
        DbUtil.close(rs);
        return t;
    }
}

