/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect.impl;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.lang.Filter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.dialect.DialectName;
import com.manatee.lowcodedb.newdb.dialect.impl.AnsiSqlDialect;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KingbaseDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 3734718212243823637L;

    public KingbaseDialect() {
        this.wrapper = new Wrapper(this.dialectName());
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, DbEntity entity) throws SQLException {
        if (entity.getInsertTypeEnum() == SqlBuilder.InsertTypeEnum.REPLACE) {
            return this.psForUpsert(conn, entity, entity.getPk().split(","));
        }
        if (entity.getInsertTypeEnum() == SqlBuilder.InsertTypeEnum.IGNORE) {
            return this.psForInsertIgnore(conn, entity);
        }
        return super.psForInsert(conn, entity);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, DbEntity ... entities) throws SQLException {
        if (ArrayUtil.isEmpty((Object[])entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        DbEntity entity = entities[0];
        SqlBuilder insert = entity.getInsertTypeEnum() == SqlBuilder.InsertTypeEnum.REPLACE ? this.psForUpsertBatch(entity, entity.getPk().split(",")) : (entity.getInsertTypeEnum() == SqlBuilder.InsertTypeEnum.IGNORE ? this.psForInsertIgnoreBatch(entity) : SqlBuilder.create(this.wrapper).insert(entity, this.dialectName()));
        Set fields = (Set)CollUtil.filter((Collection)entity.keySet(), (Filter)new Filter<String>(){

            public boolean accept(String s) {
                return StrUtil.isNotBlank((CharSequence)s);
            }
        });
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), fields, entities);
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, DbEntity entity, String ... keys) throws SQLException {
        Assert.notEmpty((Object[])keys, (String)"Keys must be not empty for Postgres.", (Object[])new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        StringBuilder updateHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
                updateHolder.append(", ");
            }
            String wrapedField = null != this.wrapper ? this.wrapper.wrap(field) : field;
            fieldsPart.append(wrapedField);
            updateHolder.append(wrapedField).append("=EXCLUDED.").append(field);
            placeHolder.append("?");
            builder.addParams(value);
        }
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("INSERT INTO ").append(tableName).append(" (").append(fieldsPart).append(") VALUES (").append(placeHolder).append(") ON CONFLICT (").append(ArrayUtil.join((Object[])keys, (CharSequence)", ")).append(") DO UPDATE SET ").append(updateHolder);
        return StatementUtil.prepareStatement(conn, builder);
    }

    @Override
    public SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getStartPosition()).append(", ").append(page.getPageSize());
    }

    @Override
    public String dialectName() {
        return DialectName.POSTGRESQL.toString();
    }

    private SqlBuilder psForUpsertBatch(DbEntity entity, String ... keys) throws SQLException {
        Assert.notEmpty((Object[])keys, (String)"Keys must be not empty for Postgres.", (Object[])new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        StringBuilder updateHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
                updateHolder.append(", ");
            }
            String wrapedField = null != this.wrapper ? this.wrapper.wrap(field) : field;
            fieldsPart.append(wrapedField);
            updateHolder.append(wrapedField).append("=EXCLUDED.").append(field);
            placeHolder.append("?");
            builder.addParams(value);
        }
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("INSERT INTO ").append(tableName).append(" (").append(fieldsPart).append(") VALUES (").append(placeHolder).append(") ON CONFLICT (").append(ArrayUtil.join((Object[])keys, (CharSequence)", ")).append(") DO UPDATE SET ").append(updateHolder);
        return builder;
    }

    private PreparedStatement psForInsertIgnore(Connection conn, DbEntity entity) throws SQLException {
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            String wrapedField = null != this.wrapper ? this.wrapper.wrap(field) : field;
            fieldsPart.append(wrapedField);
            placeHolder.append("?");
            builder.addParams(value);
        }
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("INSERT INTO ").append(tableName).append(" (").append(fieldsPart).append(") VALUES (").append(placeHolder).append(") ON CONFLICT DO NOTHING");
        return StatementUtil.prepareStatement(conn, builder);
    }

    private SqlBuilder psForInsertIgnoreBatch(DbEntity entity) throws SQLException {
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            String wrapedField = null != this.wrapper ? this.wrapper.wrap(field) : field;
            fieldsPart.append(wrapedField);
            placeHolder.append("?");
            builder.addParams(value);
        }
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("INSERT INTO ").append(tableName).append(" (").append(fieldsPart).append(") VALUES (").append(placeHolder).append(") ON CONFLICT DO NOTHING");
        return builder;
    }

    @Override
    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getSchemas(conn);
    }

    @Override
    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getSchema();
        }
        return MetaUtil.getTablesBySchema(conn, null, schema, tableName);
    }

    @Override
    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable(conn, null, schema, tableName);
    }
}

