/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect.impl;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.lang.Filter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.dialect.DialectName;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.DBQuery;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AnsiSqlDialect
implements Dialect {
    private static final long serialVersionUID = 2088101129774974580L;
    protected Wrapper wrapper = new Wrapper(this.dialectName());

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, DbEntity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        return StatementUtil.prepareStatement(conn, insert);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, DbEntity ... entities) throws SQLException {
        if (ArrayUtil.isEmpty((Object[])entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entities[0], this.dialectName());
        Set fields = (Set)CollUtil.filter((Collection)entities[0].keySet(), (Filter)new Filter<String>(){

            public boolean accept(String s) {
                return StrUtil.isNotBlank((CharSequence)s);
            }
        });
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), fields, entities);
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, DBQuery query) throws SQLException {
        Assert.notNull((Object)query, (String)"query must be not null !", (Object[])new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty((Object[])where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(query.getFirstTableName()).where(where);
        return StatementUtil.prepareStatement(conn, delete);
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, DbEntity entity, DBQuery query) throws SQLException {
        Assert.notNull((Object)query, (String)"query must be not null !", (Object[])new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty((Object[])where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepare statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(where);
        return StatementUtil.prepareStatement(conn, update);
    }

    @Override
    public PreparedStatement psForUpdateBatch(Connection conn, Collection<Map> recordAndWhereList) throws SQLException {
        Assert.notNull(recordAndWhereList, (String)"update must be not null !", (Object[])new Object[0]);
        StringBuilder allSql = new StringBuilder();
        if (!StringUtils.equals((CharSequence)this.dialectName(), (CharSequence)DialectName.MYSQL.toString()) && !StringUtils.equals((CharSequence)this.dialectName(), (CharSequence)DialectName.POSTGRESQL.toString())) {
            allSql.append("begin ");
        }
        ArrayList<Object> allParams = new ArrayList<Object>();
        for (Map map : recordAndWhereList) {
            DBQuery query = (DBQuery)map.get("query");
            DbEntity entity = (DbEntity)((Object)map.get("record"));
            Condition[] where = query.getWhere();
            SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(where);
            if (!StringUtils.isNotEmpty((CharSequence)update.build())) continue;
            String sql = update.build();
            if (!sql.endsWith(";")) {
                sql = sql + ";";
            }
            allSql.append(sql);
            List<Object> params = update.getParamValues();
            allParams.addAll(params);
        }
        if (!StringUtils.equals((CharSequence)this.dialectName(), (CharSequence)DialectName.MYSQL.toString()) && !StringUtils.equals((CharSequence)this.dialectName(), (CharSequence)DialectName.POSTGRESQL.toString())) {
            allSql.append(" end;");
        }
        return StatementUtil.prepareStatement(conn, allSql.toString(), allParams);
    }

    @Override
    public PreparedStatement psForFind(Connection conn, DBQuery query) throws SQLException {
        return this.psForPage(conn, query);
    }

    @Override
    public PreparedStatement psForPage(Connection conn, DBQuery query) throws SQLException {
        Assert.notNull((Object)query, (String)"query must be not null !", (Object[])new Object[0]);
        if (StrUtil.hasBlank((CharSequence[])query.getTableNames())) {
            throw new DbRuntimeException("Table name must be not empty !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(query.getFields()).from(query.getTableNames());
        this.wrapJoinSql(find, query);
        find.orderBy(query.getOrders());
        if (query.getGetOne()) {
            query.setPage(Page.of(0, 1));
        }
        return this.psForPage(conn, find, query.getPage());
    }

    @Override
    public PreparedStatement psForPage(Connection conn, SqlBuilder sqlBuilder, Page page) throws SQLException {
        if (null != page) {
            sqlBuilder = this.wrapPageSql(sqlBuilder, page);
        }
        return StatementUtil.prepareStatement(conn, sqlBuilder);
    }

    @Override
    public PreparedStatement psForCount(Connection conn, DBQuery query) throws SQLException {
        SqlBuilder find = SqlBuilder.create(this.wrapper).select("COUNT(*)").from(query.getTableNames());
        this.wrapJoinSql(find, query);
        return this.psForPage(conn, find, null);
    }

    @Override
    public PreparedStatement psForCount(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        sqlBuilder = sqlBuilder.insertPreFragment("SELECT count(*) from(").append(") manatee_alias_count_");
        return this.psForPage(conn, sqlBuilder, null);
    }

    @Override
    public SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getPageSize()).append(" offset ").append(page.getStartPosition());
    }

    protected SqlBuilder wrapJoinSql(SqlBuilder find, DBQuery query) {
        String firstTableName = query.getFirstTableName();
        List firstTableNameSplit = StrUtil.split((CharSequence)firstTableName, (char)'.', (int)2);
        if (firstTableNameSplit.size() >= 2) {
            firstTableName = (String)firstTableNameSplit.get(1);
        }
        HashMap<String, Condition[]> wheres = new HashMap<String, Condition[]>();
        if (query.getJoins() != null) {
            for (Join join : query.getJoins()) {
                String tableName = join.getQuery().getFirstTableName();
                List tableNameSplit = StrUtil.split((CharSequence)tableName, (char)'.', (int)2);
                if (tableNameSplit.size() >= 2) {
                    tableName = (String)tableNameSplit.get(1);
                }
                List<String[]> ons = join.getOn();
                StringBuilder onSb = new StringBuilder();
                int index = 1;
                for (String[] on : ons) {
                    String tableAndFiled = firstTableName + '.' + on[0];
                    String joinTableAndFiled = tableName + '.' + on[2];
                    String onStr = this.wrapper.wrap(tableAndFiled) + on[1] + this.wrapper.wrap(joinTableAndFiled);
                    onSb.append(onStr);
                    if (index < ons.size()) {
                        onSb.append(" and ");
                    }
                    ++index;
                }
                find.join(join.getQuery().getFirstTableName(), join.getJoinTypeEnum()).on(onSb.toString());
                Condition[] where = join.getQuery().getWhere();
                wheres.put(tableName, where);
            }
        }
        return find.where(query.getWhere());
    }

    @Override
    public String pageCountSql(String sql) {
        sql = sql.trim();
        return "select count(*) from (" + sql + ") count_table";
    }

    @Override
    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getCatalogs(conn);
    }

    @Override
    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getCatalog();
        }
        return MetaUtil.getTablesBySchema(conn, schema, null, tableName);
    }

    @Override
    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable(conn, schema, null, tableName);
    }

    @Override
    public String dialectName() {
        return DialectName.ANSI.name();
    }
}

