/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dataModel;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InitDataModelTable {
    private static final Logger log = LoggerFactory.getLogger(InitDataModelTable.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Autowired
    private BaseModuleUtil baseModuleUtil;
    @Autowired
    private DBReadUtil dbReadUtil;

    @PostConstruct
    public void initBaseTable() {
        String lowcodeLogicBase = "lowcode_logic_base";
        String lowcodeLogicAttribute = "lowcode_logic_attribute";
        String lowcodeLogicBehavior = "lowcode_logic_behavior";
        String lowcodeLogicBehaviorParams = "lowcode_logic_behavior_params";
        String lowcodeLogicBehaviorRel = "lowcode_logic_behavior_rel";
        String lowcodeLogicModuleRel = "lowcode_logic_module_rel";
        if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
            lowcodeLogicBase = "LOWCODE_LOGIC_BASE";
            lowcodeLogicAttribute = "LOWCODE_LOGIC_ATTRIBUTE";
            lowcodeLogicBehavior = "LOWCODE_LOGIC_BEHAVIOR";
            lowcodeLogicBehaviorParams = "LOWCODE_LOGIC_BEHAVIOR_PARAMS";
            lowcodeLogicBehaviorRel = "LOWCODE_LOGIC_BEHAVIOR_REL";
            lowcodeLogicModuleRel = "LOWCODE_LOGIC_MODULE_REL";
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeLogicBase)) {
            this.baseModuleUtil.initBaseTable("lowcode_logic_base");
        } else {
            String logicTypeKey = "logic_type";
            String logicConfKey = "logic_conf";
            String physicalDatasourceKey = "physical_datasource";
            String logicVersionKey = "logic_version";
            if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
                logicTypeKey = "LOGIC_TYPE";
                logicConfKey = "LOGIC_CONF";
                physicalDatasourceKey = "PHYSICAL_DATASOURCE";
                logicVersionKey = "LOGIC_VERSION";
            }
            if (!this.isExistFiled(lowcodeLogicBase, logicTypeKey)) {
                this.executeSqlScript("lowcode_logic_base", "1.11.2");
            }
            if (!this.isExistFiled(lowcodeLogicBase, logicConfKey)) {
                this.executeSqlScript("lowcode_logic_base", "1.11.3");
            }
            if (!this.isExistFiled(lowcodeLogicBase, physicalDatasourceKey)) {
                this.executeSqlScript("lowcode_logic_base", "1.11.5");
            }
            if (!this.isExistFiled(lowcodeLogicBase, logicVersionKey)) {
                this.executeSqlScript("lowcode_logic_base", "1.11.11");
            }
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeLogicAttribute)) {
            this.baseModuleUtil.initBaseTable("lowcode_logic_attribute");
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeLogicBehavior)) {
            this.baseModuleUtil.initBaseTable("lowcode_logic_behavior");
        } else {
            String validIdKey = "valid_id";
            if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
                validIdKey = "VALID_ID";
            }
            if (!this.isExistFiled(lowcodeLogicBehavior, validIdKey)) {
                this.executeSqlScript("lowcode_logic_behavior", "1.11.3");
            }
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeLogicBehaviorParams)) {
            this.baseModuleUtil.initBaseTable("lowcode_logic_behavior_params");
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeLogicBehaviorRel)) {
            this.baseModuleUtil.initBaseTable("lowcode_logic_behavior_rel");
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeLogicModuleRel)) {
            this.baseModuleUtil.initBaseTable("lowcode_logic_module_rel");
        }
    }

    private boolean isExistFiled(String table, String filed) {
        String id = "id";
        if (this.defaultDatabaseProductName.equals("dameng")) {
            table = "\"" + table + "\"";
            id = "ID";
        }
        String sql = "select " + filed + " from " + table + " where " + id + " = 0";
        try {
            DBQuery dbQuery = new DBQuery();
            dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
            dbQuery.setDb("default");
            dbQuery.setSelectOne(Boolean.valueOf(true));
            dbQuery.setSql(sql);
            this.dbReadUtil.executeSelectSql(dbQuery, null);
            return true;
        }
        catch (BizException e) {
            return false;
        }
    }

    private void executeSqlScript(String table, String version) {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
        String initSql = BaseModuleUtil.parseFile((String)("initTableFiles/" + table + "/update/" + this.defaultDatabaseProductName + "_" + version + ".sql"));
        if (initSql != null && initSql.contains(";")) {
            String[] initSqlArray = initSql.split(";");
            try {
                for (String sql : initSqlArray) {
                    log.debug(sql);
                    dbQuery.setSql(sql);
                    this.dbReadUtil.executeNotSelectStatementSql(dbQuery, null);
                }
            }
            catch (BizException e) {
                log.error("\u53d8\u66f4\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u6267\u884c", (Object)table);
            }
        } else {
            dbQuery.setSql(initSql);
            try {
                this.dbReadUtil.executeNotSelectSql(dbQuery, null);
            }
            catch (BizException e) {
                log.error("\u53d8\u66f4\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u6267\u884c", (Object)table);
            }
        }
    }
}

