/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.manatee.redis.config.RedisSentinelProperties;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Component
public class RedisSentinelClientInit {
    private static final Logger log = LoggerFactory.getLogger(RedisSentinelClientInit.class);
    private static volatile JedisSentinelPool readPool = null;
    private static volatile JedisSentinelPool writePool = null;
    @Autowired
    private RedisSentinelProperties redisSentinelProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Jedis getReadPoolInstance() {
        if (null != readPool) return this.getJedis(readPool);
        Class<RedisSentinelClientInit> clazz = RedisSentinelClientInit.class;
        synchronized (RedisSentinelClientInit.class) {
            if (null != readPool) return this.getJedis(readPool);
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxIdle(8);
            poolConfig.setMaxTotal(50);
            poolConfig.setMaxWaitMillis(100000L);
            HashSet<String> nodes = new HashSet<String>();
            for (String url : this.redisSentinelProperties.getNodes()) {
                nodes.add(url);
            }
            readPool = StringUtils.isBlank((CharSequence)this.redisSentinelProperties.getPassword()) ? new JedisSentinelPool(this.redisSentinelProperties.getMaster(), nodes, (GenericObjectPoolConfig)poolConfig, 10000) : new JedisSentinelPool(this.redisSentinelProperties.getMaster(), nodes, (GenericObjectPoolConfig)poolConfig, 10000, this.redisSentinelProperties.getPassword());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getJedis(readPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Jedis getWritePoolInstance() {
        if (null != writePool) return this.getJedis(writePool);
        Class<RedisSentinelClientInit> clazz = RedisSentinelClientInit.class;
        synchronized (RedisSentinelClientInit.class) {
            if (null != writePool) return this.getJedis(writePool);
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(1000);
            poolConfig.setMaxIdle(8);
            poolConfig.setMaxTotal(50);
            poolConfig.setMaxWaitMillis(100000L);
            HashSet<String> nodes = new HashSet<String>();
            for (String url : this.redisSentinelProperties.getNodes()) {
                nodes.add(url);
            }
            writePool = StringUtils.isBlank((CharSequence)this.redisSentinelProperties.getPassword()) ? new JedisSentinelPool(this.redisSentinelProperties.getMaster(), nodes, (GenericObjectPoolConfig)poolConfig, 100) : new JedisSentinelPool(this.redisSentinelProperties.getMaster(), nodes, (GenericObjectPoolConfig)poolConfig, 100, this.redisSentinelProperties.getPassword());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getJedis(writePool);
        }
    }

    public Jedis getJedis(JedisSentinelPool pool) {
        Jedis jedis = null;
        try {
            jedis = pool.getResource();
        }
        catch (JedisConnectionException e) {
            pool = null;
            log.error("[RedisClientInit.getReadyOnlyJedis]_exception", (Object)"getResource is fail", (Object)e);
        }
        return jedis;
    }

    public void returnRes(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }
}

