/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.pdf.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.pdf.util.TextWaterMark;
import fr.opensagres.poi.xwpf.converter.core.ImageManager;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.xhtml.Base64EmbedImgManager;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class WordToPdfUtil {
    private static final Logger log = LoggerFactory.getLogger(WordToPdfUtil.class);

    public static void docxToPdf(InputStream inStream, OutputStream outStream, String fileWatermark) throws Exception {
        com.itextpdf.text.Document pdfDocument = new com.itextpdf.text.Document((Rectangle)new RectangleReadOnly(595.0f, 842.0f));
        PdfWriter pdfWriter = PdfWriter.getInstance((com.itextpdf.text.Document)pdfDocument, (OutputStream)outStream);
        XWPFDocument doc = new XWPFDocument(inStream);
        pdfWriter.setInitialLeading(20.0f);
        List plist = doc.getParagraphs();
        pdfDocument.open();
        pdfDocument.newPage();
        if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
            try {
                pdfWriter.setPageEvent((PdfPageEvent)new TextWaterMark(fileWatermark));
            }
            catch (Exception e) {
                log.error("pdf\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", (Throwable)e);
            }
        }
        ClassPathResource resource = new ClassPathResource("font/msyh.ttf");
        InputStream inputStream = resource.getInputStream();
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        BaseFont baseFont = BaseFont.createFont((String)"msyh.ttf", (String)"Identity-H", (boolean)true, (boolean)true, (byte[])bytes, null);
        for (int i = 0; i < plist.size(); ++i) {
            XWPFParagraph pa = (XWPFParagraph)plist.get(i);
            List runs = pa.getRuns();
            for (int j = 0; j < runs.size(); ++j) {
                XWPFRun run = (XWPFRun)runs.get(j);
                List piclist = run.getEmbeddedPictures();
                for (XWPFPicture pic : piclist) {
                    XWPFPictureData picdata = pic.getPictureData();
                    byte[] bytepic = picdata.getData();
                    Image imag = Image.getInstance((byte[])bytepic);
                    pdfDocument.add((com.itextpdf.text.Element)imag);
                }
                Font font = new Font(baseFont, 11.0f, 0, BaseColor.BLACK);
                String text = run.getText(-1);
                if (text == null) continue;
                byte[] bs = text.getBytes();
                String str = new String(bs);
                Chunk chObj1 = new Chunk(str, font);
                pdfDocument.add((com.itextpdf.text.Element)chObj1);
            }
            pdfDocument.add((com.itextpdf.text.Element)new Chunk(Chunk.NEWLINE));
        }
        pdfDocument.close();
        pdfWriter.close();
        try {
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
        catch (IOException e) {
            log.error("docx\u8f6cpdf\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u4f53\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
        }
    }

    public static void docToPdf(InputStream inStream, OutputStream outStream, String fileWatermark) {
        try {
            String imageDir = GlobalConf.TEMP_DIRECTORY + "/docToPdfImage";
            File folder = new File(imageDir);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String html = WordToPdfUtil.docToHtml(inStream, imageDir + "/");
            html = WordToPdfUtil.formatHtml(html);
            WordToPdfUtil.htmlToPdf(html, outStream, fileWatermark);
            WordToPdfUtil.deleteFolder(folder);
        }
        catch (Exception e) {
            log.error("doc\u8f6cpdf\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public static void htmlToPdf(String html, OutputStream outStream, String fileWatermark) throws Exception {
        com.itextpdf.text.Document pdfDocument = new com.itextpdf.text.Document((Rectangle)new RectangleReadOnly(595.0f, 842.0f));
        PdfWriter pdfWriter = PdfWriter.getInstance((com.itextpdf.text.Document)pdfDocument, (OutputStream)outStream);
        pdfDocument.open();
        pdfDocument.newPage();
        if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
            try {
                pdfWriter.setPageEvent((PdfPageEvent)new TextWaterMark(fileWatermark));
            }
            catch (Exception e) {
                log.error("pdf\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", (Throwable)e);
            }
        }
        ClassPathResource resource = new ClassPathResource("font/msyhbd.ttf");
        InputStream inputStream = resource.getInputStream();
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        final BaseFont baseFont = BaseFont.createFont((String)"msyhbd.ttf", (String)"Identity-H", (boolean)true, (boolean)true, (byte[])bytes, null);
        ByteArrayInputStream bais = new ByteArrayInputStream(html.getBytes());
        XMLWorkerHelper.getInstance().parseXHtml(pdfWriter, pdfDocument, (InputStream)bais, Charset.forName("UTF-8"), new FontProvider(){

            public boolean isRegistered(String s) {
                return false;
            }

            public Font getFont(String s, String s1, boolean embedded, float size, int style, BaseColor baseColor) {
                Font font = null;
                try {
                    font = new Font(baseFont, size, style, baseColor);
                    font.setColor(baseColor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return font;
            }
        });
        pdfDocument.close();
        pdfWriter.close();
        if (bais != null) {
            try {
                bais.close();
            }
            catch (IOException e) {
                log.error("html\u8f6cpdf\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        try {
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
        catch (IOException e) {
            log.error("doc\u8f6cpdf\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String docToHtml(InputStream inputStream, final String imageDir) {
        String content = null;
        ByteArrayOutputStream baos = null;
        try {
            HWPFDocument wordDocument = new HWPFDocument(inputStream);
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                    File file = new File(imageDir + suggestedName);
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(file);
                        fos.write(content);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return imageDir + suggestedName;
                }
            });
            wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
            org.w3c.dom.Document htmlDocument = wordToHtmlConverter.getDocument();
            DOMSource domSource = new DOMSource(htmlDocument);
            baos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(baos);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            serializer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            log.error("doc\u8f6chtml\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            try {
                if (baos != null) {
                    content = new String(baos.toByteArray(), "utf-8");
                    baos.close();
                }
            }
            catch (Exception e) {
                log.error("doc\u8f6chtml\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        return content;
    }

    public static String formatHtml(String html) {
        Document doc = Jsoup.parse((String)html);
        String style = doc.attr("style");
        if (StringUtils.isNotEmpty((CharSequence)style) && style.contains("width")) {
            doc.attr("style", "");
        }
        Elements divs = doc.select("div");
        for (Element div : divs) {
            String divStyle = div.attr("style");
            if (!StringUtils.isNotEmpty((CharSequence)divStyle) || !divStyle.contains("width")) continue;
            div.attr("style", "");
        }
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
        return doc.html();
    }

    public static void deleteFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                WordToPdfUtil.deleteFolder(file);
            }
        }
        folder.delete();
    }

    public static void docxHtmlToPdf(InputStream inStream, OutputStream outStream, String fileWatermark) {
        try {
            String html = WordToPdfUtil.docxToHtml(inStream);
            html = WordToPdfUtil.formatHtml(html);
            WordToPdfUtil.htmlToPdf(html, outStream, fileWatermark);
        }
        catch (Exception e) {
            log.error("doc\u8f6cpdf\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String docxToHtml(InputStream inputStream) throws BizException {
        String content = null;
        StringWriter writer = null;
        try {
            XWPFDocument document = new XWPFDocument(inputStream);
            XHTMLOptions options = XHTMLOptions.create();
            options.setIgnoreStylesIfUnused(false);
            options.setFragment(true);
            options.indent(Integer.valueOf(3)).setImageManager((ImageManager)new Base64EmbedImgManager());
            writer = new StringWriter();
            XHTMLConverter xhtmlConverter = (XHTMLConverter)XHTMLConverter.getInstance();
            xhtmlConverter.convert(document, (Writer)writer, (Options)options);
        }
        catch (Exception e) {
            log.error("docx\u8f6cHtml\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    content = writer.toString();
                }
            }
            catch (Exception e) {
                log.error("docx\u8f6chtml\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        return content;
    }
}

