/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.pdf.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.pdf.util.TextWaterMark;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public final class ExcelToPdfUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelToPdfUtil.class);

    public static void excelToPdf(String excelPath, String pdfPath) {
        try (InputStream in = Files.newInputStream(Paths.get(excelPath, new String[0]), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(Paths.get(pdfPath, new String[0]), new OpenOption[0]);){
            ExcelToPdfUtil.excelToPdf(in, out, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void excelToPdf(InputStream inStream, OutputStream outStream, String fileWatermark) throws Exception {
        List<Sheet> sheetList = ExcelToPdfUtil.getPoiSheetByFileStream(inStream);
        if (sheetList != null) {
            ArrayList<PdfPTable> tables = new ArrayList<PdfPTable>(sheetList.size());
            for (Sheet sheet : sheetList) {
                PdfPTable table = ExcelToPdfUtil.createPdfPTable(sheet);
                tables.add(table);
            }
            ExcelToPdfUtil.createPdfTableAndWriteDocument(outStream, tables, fileWatermark);
        }
    }

    public static PdfPTable createPdfPTable(Sheet sheet) throws Exception {
        float[] widths = ExcelToPdfUtil.getColWidth(sheet);
        if (widths == null) {
            return new PdfPTable(1);
        }
        PdfPTable table = new PdfPTable(widths);
        table.setWidthPercentage(100.0f);
        int colCount = widths.length;
        ClassPathResource resource = new ClassPathResource("font/msyh.ttf");
        InputStream inputStream = resource.getInputStream();
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        BaseFont baseFont = BaseFont.createFont((String)"msyh.ttf", (String)"Identity-H", (boolean)true, (boolean)true, (byte[])bytes, null);
        for (int rowIndex = sheet.getFirstRowNum(); rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (Objects.isNull(row)) {
                for (int i = 0; i < colCount; ++i) {
                    table.addCell(ExcelToPdfUtil.createPdfPCell(null, 0, Float.valueOf(13.0f), null));
                }
                continue;
            }
            for (int columnIndex = 0; (columnIndex < row.getLastCellNum() || columnIndex < colCount) && columnIndex > -1; ++columnIndex) {
                PdfPCell pCell = ExcelToPdfUtil.excelCellToPdfCell(sheet, row.getCell(columnIndex), baseFont);
                if (ExcelToPdfUtil.isMergedRegion(sheet, rowIndex, columnIndex)) {
                    boolean mergedCell;
                    int[] span = ExcelToPdfUtil.getMergedSpan(sheet, rowIndex, columnIndex);
                    boolean bl = mergedCell = span[0] == 1 && span[1] == 1;
                    if (mergedCell) continue;
                    pCell.setRowspan(span[0]);
                    pCell.setColspan(span[1]);
                }
                table.addCell(pCell);
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u4f53\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
        }
        return table;
    }

    private static PdfPCell excelCellToPdfCell(Sheet sheet, Cell excelCell, BaseFont baseFont) throws Exception {
        PdfPCell pCell;
        if (Objects.isNull(excelCell)) {
            return ExcelToPdfUtil.createPdfPCell(null, 0, Float.valueOf(13.0f), null);
        }
        int rowIndex = excelCell.getRowIndex();
        int columnIndex = excelCell.getColumnIndex();
        List<PicturesInfo> infos = ExcelToPdfUtil.getAllPictureInfos(sheet, rowIndex, rowIndex, columnIndex, columnIndex, false);
        if (CollUtil.isNotEmpty(infos)) {
            pCell = new PdfPCell(Image.getInstance((byte[])infos.get(0).getPictureData()));
        } else {
            Font excelFont = ExcelToPdfUtil.getExcelFont(sheet, excelCell);
            com.itextpdf.text.Font pdFont = new com.itextpdf.text.Font(baseFont, (float)excelFont.getFontHeightInPoints(), excelFont.getBold() ? 1 : 0, BaseColor.BLACK);
            Integer border = ExcelToPdfUtil.hasBorder(excelCell) ? null : Integer.valueOf(0);
            String excelCellValue = ExcelToPdfUtil.getExcelCellValue(excelCell);
            pCell = ExcelToPdfUtil.createPdfPCell(excelCellValue, border, Float.valueOf(excelCell.getRow().getHeightInPoints()), pdFont);
        }
        pCell.setHorizontalAlignment(ExcelToPdfUtil.getHorAlign(excelCell.getCellStyle().getAlignment().getCode()));
        pCell.setVerticalAlignment(ExcelToPdfUtil.getVerAlign(excelCell.getCellStyle().getVerticalAlignment().getCode()));
        return pCell;
    }

    private static void createPdfTableAndWriteDocument(OutputStream outStream, PdfPTable table) throws DocumentException {
        Document document = new Document((Rectangle)new RectangleReadOnly(595.0f, 842.0f));
        PdfWriter.getInstance((Document)document, (OutputStream)outStream);
        document.setMargins(10.0f, 10.0f, 10.0f, 10.0f);
        document.open();
        document.add((Element)table);
        document.close();
    }

    private static void createPdfTableAndWriteDocument(OutputStream outStream, List<PdfPTable> tables, String fileWatermark) throws DocumentException {
        Document document = new Document((Rectangle)new RectangleReadOnly(595.0f, 842.0f));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outStream);
        document.setMargins(10.0f, 10.0f, 10.0f, 10.0f);
        document.open();
        document.newPage();
        if (StringUtils.isNotEmpty((CharSequence)fileWatermark)) {
            try {
                pdfWriter.setPageEvent((PdfPageEvent)new TextWaterMark(fileWatermark));
            }
            catch (Exception e) {
                log.error("pdf\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", (Throwable)e);
            }
        }
        for (PdfPTable table : tables) {
            document.add((Element)table);
            document.add((Element)new Paragraph("\n"));
        }
        document.close();
        pdfWriter.close();
        try {
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
        catch (IOException e) {
            log.error("excel\u8f6cpdf\u5173\u95edio\u6d41\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public static List<Sheet> getPoiSheetByFileStream(InputStream inputStream) throws IOException {
        Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
        int numberOfSheets = workbook.getNumberOfSheets();
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>(numberOfSheets);
        for (int i = 0; i < numberOfSheets; ++i) {
            sheetList.add(workbook.getSheetAt(i));
        }
        return sheetList;
    }

    private static PdfPCell createPdfPCell(String content, Integer border, Float minimumHeight, com.itextpdf.text.Font pdFont) {
        String contentValue = content == null ? "" : content;
        com.itextpdf.text.Font pdFontNew = pdFont == null ? new com.itextpdf.text.Font() : pdFont;
        PdfPCell pCell = new PdfPCell(new Phrase(contentValue, pdFontNew));
        if (Objects.nonNull(border)) {
            pCell.setBorder(border.intValue());
        }
        if (Objects.nonNull(minimumHeight)) {
            pCell.setMinimumHeight(minimumHeight.floatValue());
        }
        return pCell;
    }

    private static int getVerAlign(int align) {
        switch (align) {
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
        }
        return 5;
    }

    private static int getHorAlign(int align) {
        switch (align) {
            case 1: {
                return 0;
            }
            case 3: {
                return 2;
            }
        }
        return 1;
    }

    private static Font getExcelFont(Sheet sheet, Cell cell) {
        if (sheet instanceof HSSFSheet) {
            Workbook workbook = sheet.getWorkbook();
            return ((HSSFCell)cell).getCellStyle().getFont(workbook);
        }
        return ((XSSFCell)cell).getCellStyle().getFont();
    }

    private static boolean hasBorder(Cell excelCell) {
        short right;
        short left;
        short bottom;
        short top = excelCell.getCellStyle().getBorderTop().getCode();
        return top + (bottom = excelCell.getCellStyle().getBorderBottom().getCode()) + (left = excelCell.getCellStyle().getBorderLeft().getCode()) + (right = excelCell.getCellStyle().getBorderRight().getCode()) > 2;
    }

    private static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    private static int[] getMergedSpan(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int[] span = new int[]{1, 1};
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (firstColumn != column || firstRow != row) continue;
            span[0] = lastRow - firstRow + 1;
            span[1] = lastColumn - firstColumn + 1;
            break;
        }
        return span;
    }

    private static float[] getColWidth(Sheet sheet) {
        int rowNum = ExcelToPdfUtil.getMaxColRowNum(sheet);
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        int cellCount = row.getPhysicalNumberOfCells();
        int[] colWidths = new int[cellCount];
        int sum = 0;
        for (int i = row.getFirstCellNum(); i < cellCount; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            colWidths[i] = sheet.getColumnWidth(i);
            sum += sheet.getColumnWidth(i);
        }
        float[] colWidthPer = new float[cellCount];
        for (int i = row.getFirstCellNum(); i < cellCount; ++i) {
            colWidthPer[i] = (float)colWidths[i] / (float)sum * 100.0f;
        }
        return colWidthPer;
    }

    private static int getMaxColRowNum(Sheet sheet) {
        int rowNum = 0;
        int maxCol = 0;
        for (int r = sheet.getFirstRowNum(); r < sheet.getPhysicalNumberOfRows(); ++r) {
            Row row = sheet.getRow(r);
            if (row == null || maxCol >= row.getPhysicalNumberOfCells()) continue;
            maxCol = row.getPhysicalNumberOfCells();
            rowNum = r;
        }
        return rowNum;
    }

    public static String getExcelCellValue(Cell excelCell) {
        if (excelCell == null) {
            return "";
        }
        CellType cellType = excelCell.getCellType();
        if (cellType == CellType.STRING) {
            return excelCell.getStringCellValue();
        }
        if (cellType == CellType.BOOLEAN) {
            return String.valueOf(excelCell.getBooleanCellValue());
        }
        if (cellType == CellType.FORMULA) {
            return excelCell.getCellFormula();
        }
        if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)excelCell)) {
                SimpleDateFormat sdf;
                if (excelCell.getCellStyle().getDataFormat() == 14) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd");
                } else if (excelCell.getCellStyle().getDataFormat() == 21) {
                    sdf = new SimpleDateFormat("HH:mm:ss");
                } else if (excelCell.getCellStyle().getDataFormat() == 22) {
                    sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                } else {
                    throw new RuntimeException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef!!!");
                }
                Date date = excelCell.getDateCellValue();
                return sdf.format(date);
            }
            DataFormatter formatter = new DataFormatter();
            return formatter.formatCellValue(excelCell);
        }
        if (cellType == CellType.ERROR) {
            return "\u975e\u6cd5\u5b57\u7b26";
        }
        return "";
    }

    public static List<PicturesInfo> getAllPictureInfos(Sheet sheet, boolean onlyInternal) throws Exception {
        return ExcelToPdfUtil.getAllPictureInfos(sheet, null, null, null, null, onlyInternal);
    }

    public static List<PicturesInfo> getAllPictureInfos(Sheet sheet, Integer minRow, Integer maxRow, Integer minCol, Integer maxCol, boolean onlyInternal) throws Exception {
        if (sheet instanceof HSSFSheet) {
            return ExcelToPdfUtil.getXLSAllPictureInfos((HSSFSheet)sheet, minRow, maxRow, minCol, maxCol, onlyInternal);
        }
        if (sheet instanceof XSSFSheet) {
            return ExcelToPdfUtil.getXLSXAllPictureInfos((XSSFSheet)sheet, minRow, maxRow, minCol, maxCol, onlyInternal);
        }
        throw new Exception("\u672a\u5904\u7406\u7c7b\u578b\uff0c\u6ca1\u6709\u4e3a\u8be5\u7c7b\u578b\u6dfb\u52a0\uff1aGetAllPicturesInfos()\u6269\u5c55\u65b9\u6cd5\uff01");
    }

    private static List<PicturesInfo> getXLSAllPictureInfos(HSSFSheet sheet, Integer minRow, Integer maxRow, Integer minCol, Integer maxCol, Boolean onlyInternal) {
        ArrayList<PicturesInfo> picturesInfoList = new ArrayList<PicturesInfo>();
        HSSFPatriarch shapeContainer = sheet.getDrawingPatriarch();
        if (shapeContainer == null) {
            return picturesInfoList;
        }
        List shapeList = shapeContainer.getChildren();
        for (HSSFShape shape : shapeList) {
            if (!(shape instanceof HSSFPicture) || !(shape.getAnchor() instanceof HSSFClientAnchor)) continue;
            HSSFPicture picture = (HSSFPicture)shape;
            HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
            if (!ExcelToPdfUtil.isInternalOrIntersect(minRow, maxRow, minCol, maxCol, anchor.getRow1(), anchor.getRow2(), anchor.getCol1(), anchor.getCol2(), onlyInternal)) continue;
            HSSFPictureData pictureData = picture.getPictureData();
            picturesInfoList.add(new PicturesInfo().setMinRow(anchor.getRow1()).setMaxRow(anchor.getRow2()).setMinCol(anchor.getCol1()).setMaxCol(anchor.getCol2()).setPictureData(pictureData.getData()).setExt(pictureData.getMimeType()));
        }
        return picturesInfoList;
    }

    private static List<PicturesInfo> getXLSXAllPictureInfos(XSSFSheet sheet, Integer minRow, Integer maxRow, Integer minCol, Integer maxCol, Boolean onlyInternal) {
        ArrayList<PicturesInfo> picturesInfoList = new ArrayList<PicturesInfo>();
        List documentPartList = sheet.getRelations();
        for (POIXMLDocumentPart documentPart : documentPartList) {
            if (!(documentPart instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)documentPart;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture picture;
                XSSFClientAnchor anchor;
                if (!(shape instanceof XSSFPicture) || !ExcelToPdfUtil.isInternalOrIntersect(minRow, maxRow, minCol, maxCol, (anchor = (picture = (XSSFPicture)shape).getPreferredSize()).getRow1(), anchor.getRow2(), anchor.getCol1(), anchor.getCol2(), onlyInternal)) continue;
                XSSFPictureData pictureData = picture.getPictureData();
                picturesInfoList.add(new PicturesInfo().setMinRow(anchor.getRow1()).setMaxRow(anchor.getRow2()).setMinCol(anchor.getCol1()).setMaxCol(anchor.getCol2()).setPictureData(pictureData.getData()).setExt(pictureData.getMimeType()));
            }
        }
        return picturesInfoList;
    }

    private static boolean isInternalOrIntersect(Integer rangeMinRow, Integer rangeMaxRow, Integer rangeMinCol, Integer rangeMaxCol, int pictureMinRow, int pictureMaxRow, int pictureMinCol, int pictureMaxCol, Boolean onlyInternal) {
        int _rangeMaxCol;
        int _rangeMinRow = rangeMinRow == null ? pictureMinRow : rangeMinRow;
        int _rangeMaxRow = rangeMaxRow == null ? pictureMaxRow : rangeMaxRow;
        int _rangeMinCol = rangeMinCol == null ? pictureMinCol : rangeMinCol;
        int n = _rangeMaxCol = rangeMaxCol == null ? pictureMaxCol : rangeMaxCol;
        if (onlyInternal.booleanValue()) {
            return _rangeMinRow <= pictureMinRow && _rangeMaxRow >= pictureMaxRow && _rangeMinCol <= pictureMinCol && _rangeMaxCol >= pictureMaxCol;
        }
        return Math.abs(_rangeMaxRow - _rangeMinRow) + Math.abs(pictureMaxRow - pictureMinRow) >= Math.abs(_rangeMaxRow + _rangeMinRow - pictureMaxRow - pictureMinRow) && Math.abs(_rangeMaxCol - _rangeMinCol) + Math.abs(pictureMaxCol - pictureMinCol) >= Math.abs(_rangeMaxCol + _rangeMinCol - pictureMaxCol - pictureMinCol);
    }

    private ExcelToPdfUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class PicturesInfo {
        private int minRow;
        private int maxRow;
        private int minCol;
        private int maxCol;
        private String ext;
        private byte[] pictureData;

        public byte[] getPictureData() {
            return this.pictureData;
        }

        public PicturesInfo setPictureData(byte[] pictureData) {
            this.pictureData = pictureData;
            return this;
        }

        public int getMinRow() {
            return this.minRow;
        }

        public PicturesInfo setMinRow(int minRow) {
            this.minRow = minRow;
            return this;
        }

        public int getMaxRow() {
            return this.maxRow;
        }

        public PicturesInfo setMaxRow(int maxRow) {
            this.maxRow = maxRow;
            return this;
        }

        public int getMinCol() {
            return this.minCol;
        }

        public PicturesInfo setMinCol(int minCol) {
            this.minCol = minCol;
            return this;
        }

        public int getMaxCol() {
            return this.maxCol;
        }

        public PicturesInfo setMaxCol(int maxCol) {
            this.maxCol = maxCol;
            return this;
        }

        public String getExt() {
            return this.ext;
        }

        public PicturesInfo setExt(String ext) {
            this.ext = ext;
            return this;
        }
    }
}

