/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz.util;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.quartz.constants.ScheduleConstants;
import com.manatee.quartz.domain.QuartzJob;
import com.manatee.quartz.util.CallbackQuartzDisallowConcurrentExecution;
import com.manatee.quartz.util.CronUtils;
import com.manatee.quartz.util.QuartzDisallowConcurrentExecution;
import com.manatee.quartz.util.QuartzJobExecution;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleUtils {
    private static final Logger log = LoggerFactory.getLogger(ScheduleUtils.class);

    private static Class<? extends Job> getQuartzJobClass(QuartzJob quartzJob) {
        boolean isConcurrent = "0".equals(quartzJob.getConcurrent());
        return isConcurrent ? QuartzJobExecution.class : QuartzDisallowConcurrentExecution.class;
    }

    public static TriggerKey getTriggerKey(Long jobId) {
        return TriggerKey.triggerKey((String)("TASK_CLASS_NAME" + jobId));
    }

    public static TriggerKey getCallbackTriggerKey(Long jobId) {
        return TriggerKey.triggerKey((String)("TASK_CALLBACK_CLASS_NAME" + jobId));
    }

    public static TriggerKey getTriggerKey(Long jobId, String jobGroup) {
        return TriggerKey.triggerKey((String)("TASK_CLASS_NAME" + jobId), (String)jobGroup);
    }

    public static JobKey getJobKey(Long jobId) {
        return JobKey.jobKey((String)("TASK_CLASS_NAME" + jobId));
    }

    public static JobKey getCallbackJobKey(Long jobId) {
        return JobKey.jobKey((String)("TASK_CALLBACK_CLASS_NAME" + jobId));
    }

    public static JobKey getJobKey(Long jobId, String jobGroup) {
        return JobKey.jobKey((String)("TASK_CLASS_NAME" + jobId), (String)jobGroup);
    }

    public static void createScheduleJob(Scheduler scheduler, QuartzJob job) throws SchedulerException, BizException {
        Class<? extends Job> jobClass = ScheduleUtils.getQuartzJobClass(job);
        Long jobId = job.getId();
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(ScheduleUtils.getJobKey(jobId)).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getExecuteCycle());
        cronScheduleBuilder = ScheduleUtils.handleCronScheduleMisfirePolicy(job, cronScheduleBuilder);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getTriggerKey(jobId)).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        jobDetail.getJobDataMap().put("TASK_PROPERTIES", (Object)job);
        if (scheduler.checkExists(ScheduleUtils.getJobKey(jobId))) {
            scheduler.deleteJob(ScheduleUtils.getJobKey(jobId));
        }
        if (null != CronUtils.getNextExecution(job.getExecuteCycle())) {
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        if (job.getStatus().equals(ScheduleConstants.Status.PAUSE.getValue())) {
            scheduler.pauseJob(ScheduleUtils.getJobKey(jobId));
        }
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
    }

    public static CronScheduleBuilder handleCronScheduleMisfirePolicy(QuartzJob job, CronScheduleBuilder cb) throws BizException {
        switch (job.getMisfirePolicy()) {
            case "0": {
                return cb;
            }
            case "1": {
                return cb.withMisfireHandlingInstructionIgnoreMisfires();
            }
            case "2": {
                return cb.withMisfireHandlingInstructionFireAndProceed();
            }
            case "3": {
                return cb.withMisfireHandlingInstructionDoNothing();
            }
        }
        throw new BizException(ResultCode.SYSTEM_ERROR, "The task misfire policy '" + job.getMisfirePolicy() + "' cannot be used in cron schedule tasks");
    }

    public static void modifyJobTime(Scheduler scheduler, QuartzJob job, String time) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey(job.getId());
            CronTriggerImpl trigger = (CronTriggerImpl)scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                log.info("\u4efb\u52a1\u3010{}\u3011\u91cd\u8bd5\uff0c\u6b21\u6570\uff1a{}\uff0c\u539f\u6267\u884ccron\u8868\u8fbe\u5f0f:{}\uff0c\u65b0\u6267\u884ccron\u8868\u8fbe\u5f0f:{}", new Object[]{job.getJobName(), job.getRetriedNum(), oldTime, time});
                trigger.setCronExpression(time);
                scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            log.error("\u53d8\u66f4\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void deleteJob(Scheduler scheduler, QuartzJob job) throws SchedulerException {
        scheduler.deleteJob(ScheduleUtils.getJobKey(job.getId()));
    }

    public static void createCallbackJob(Scheduler scheduler, QuartzJob job) throws SchedulerException, BizException {
        Class<CallbackQuartzDisallowConcurrentExecution> jobClass = CallbackQuartzDisallowConcurrentExecution.class;
        Long jobId = job.getId();
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(ScheduleUtils.getCallbackJobKey(jobId)).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCallbackCron());
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getCallbackTriggerKey(jobId)).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        jobDetail.getJobDataMap().put("TASK_PROPERTIES", (Object)job);
        if (scheduler.checkExists(ScheduleUtils.getCallbackJobKey(jobId))) {
            scheduler.deleteJob(ScheduleUtils.getCallbackJobKey(jobId));
        }
        if (null != CronUtils.getNextExecution(job.getExecuteCycle())) {
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
    }

    public static void modifyCallbackJobTime(Scheduler scheduler, QuartzJob job, String time) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getCallbackTriggerKey(job.getId());
            CronTriggerImpl trigger = (CronTriggerImpl)scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                log.info("\u4efb\u52a1\u3010{}\u3011\u56de\u8c03\u91cd\u8bd5\uff0c\u6b21\u6570\uff1a{}\uff0c\u539f\u6267\u884ccron\u8868\u8fbe\u5f0f:{}\uff0c\u65b0\u6267\u884ccron\u8868\u8fbe\u5f0f:{}", new Object[]{job.getJobName(), job.getCallbackNum(), oldTime, time});
                trigger.setCronExpression(time);
                scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            log.error("\u53d8\u66f4\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static void deleteCallbackJob(Scheduler scheduler, QuartzJob job) throws SchedulerException {
        scheduler.deleteJob(ScheduleUtils.getCallbackJobKey(job.getId()));
    }
}

