/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.web.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.lowcode.domain.WebResult;
import com.manatee.lowcode.util.WebUtil;
import com.manatee.lowcode.web.base.CustomizeModuleManagerBase;
import com.manatee.process.ProcessChain;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CustomizeModuleManager
extends CustomizeModuleManagerBase {
    @Resource
    private ProcessChain processChain;
    @Resource
    private WebUtil webUtil;
    @Value(value="${manatee.checkParamSecurity:true}")
    private Boolean checkParamSecurity;
    @Value(value="${manatee.checkParamSecurity.enabled:}")
    private Boolean checkParamSecurityEnabled;
    @Value(value="${manatee.checkParamSecurity.excludes:}")
    private String checkParamSecurityExcludes;

    public JSONObject customize(HttpServletRequest request, ProcessContent content) {
        String code = content.getCode();
        if (code == null) {
            code = request.getParameter("lowcodeModule");
        }
        try {
            this.initProcessContent(request, content, code);
            if (content.getProjectId() == null || content.getProjectId() > 0L) {
                if (this.checkParamSecurityEnabled != null) {
                    this.checkParamSecurity = this.checkParamSecurityEnabled;
                }
                if (this.checkParamSecurity.booleanValue()) {
                    ArrayList<String> excludes = new ArrayList<String>();
                    if (StringUtils.isNotBlank((CharSequence)this.checkParamSecurityExcludes)) {
                        for (String str : this.checkParamSecurityExcludes.split(",")) {
                            excludes.add(str);
                        }
                    }
                    if (excludes == null || !excludes.contains(code)) {
                        this.checkContentSecurity(content);
                    }
                }
            }
            HashMap map = new HashMap(content.getRequest());
            map.remove("tempContext");
            map.remove("cells");
            String params = JSONObject.toJSONString(map);
            log.info("[CustomizeModuleManager.customize]_moduleInfo,projectId: {}, moduleCode: {}, params: {}", new Object[]{content.getProjectId(), code, params});
            this.processChain.execute(content);
        }
        catch (Throwable e) {
            this.log(content, e);
        }
        WebResult result = this.webUtil.wirteToResult(content);
        if (!WebUtil.isSuccessResult(result)) {
            String re = null;
            JSONObject reJson = result.toJson();
            if (reJson != null && (re = reJson.toString()).length() > 500) {
                re = re.substring(0, 200);
            }
            log.error("[CustomizeModuleManager.customize]_biz_error,code:{},projectId:{},result:{}", new Object[]{code, content.getProjectId(), re});
            return reJson;
        }
        log.warn("[CustomizeModuleManager.customize]_success,code:{},projectId:{}", (Object)code, (Object)content.getProjectId());
        return result.toJson();
    }
}

