/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.web.base;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.HTMLFilterUtil;
import com.manatee.lowcode.util.ProcessParamUtil;
import com.manatee.lowcode.web.manager.CustomizeModuleManager;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.execute.DebugUtil;
import com.manatee.process.util.ProcessCheckUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeModuleManagerBase {
    protected static Logger log = LoggerFactory.getLogger(CustomizeModuleManager.class);
    @Resource
    private HTMLFilterUtil htmlFilterUtil;

    protected void log(ProcessContent content, Throwable e) {
        String code = content.getCode();
        content.addException(e);
        content.setInterruptLevel(Integer.valueOf(3));
        if (e instanceof BizException) {
            BizException exception = (BizException)e;
            if (!ResultCode.SYSTEM_ERROR.getCode().equals(exception.getCode())) {
                return;
            }
        }
        log.error("[CustomizeModuleManager.customize]_exception,code:{},projectId:{},param:{}", new Object[]{code, content.getProjectId(), content.getRequest(), e});
    }

    protected void initProcessContent(HttpServletRequest request, ProcessContent content, String code) throws BizException {
        String lang;
        String showErrorStack;
        if (StringUtil.isBlank((String)code)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "code_is_null");
        }
        String projectObjId = request.getParameter("lowcodeProjectId");
        String debug = request.getParameter("debug");
        String isSingle = request.getParameter("isSingle");
        if (debug != null) {
            content.putTempContent("debug", (Object)debug);
        }
        if (isSingle != null) {
            content.putTempContent("isSingle", (Object)isSingle);
        }
        if ((showErrorStack = request.getParameter("showErrorStack")) != null) {
            content.putTempContent("showErrorStack", (Object)showErrorStack);
        }
        this.initParams(request, content);
        Object cellsObj = content.getRequest("cells");
        if (cellsObj != null) {
            if (cellsObj instanceof String) {
                List<String> moduleCodeList = this.cellsModuleCode();
                if (moduleCodeList.contains(code)) {
                    try {
                        char[] decodeChar = cellsObj.toString().toCharArray();
                        for (int i = 0; i < decodeChar.length; ++i) {
                            int c = decodeChar[i];
                            decodeChar[i] = (char)(c ^= 0xA);
                        }
                        String newCells = new String(decodeChar);
                        cellsObj = JSONObject.parse((String)newCells, (Feature[])new Feature[]{Feature.OrderedField});
                    }
                    catch (Exception e) {
                        log.error("cells \u89e3\u5bc6\u5931\u8d25", (Throwable)e);
                    }
                }
                Object parse = JSONArray.parse((byte[])cellsObj.toString().getBytes(), (Feature[])new Feature[]{Feature.OrderedField});
                JSONArray cells = (JSONArray)parse;
                content.putRequest("cells", (Object)cells);
            } else {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u6d41\u7a0b\u56fe\u6570\u636e\u9700\u8981\u662f\u5b57\u7b26\u4e32");
            }
        }
        if (projectObjId != null && content.getProjectId() == null) {
            Long projectId = Long.valueOf(projectObjId + "");
            content.putTempContent("lowcodeProjectId", (Object)projectId);
        }
        content.putTempContent("lowcodeModule", (Object)code);
        String source = request.getHeader("source");
        content.putTempContent("source", (Object)source);
        String subSource = request.getHeader("subSource");
        if (subSource == null) {
            subSource = "manatee";
        }
        content.putTempContent("subSource", (Object)subSource);
        String version = request.getHeader("version");
        if (version != null) {
            content.putTempContent("version", (Object)version);
        }
        if ((lang = request.getHeader("lang")) != null) {
            content.putTempContent("lang", (Object)lang);
        }
        if (!DebugUtil.isDebug((ProcessContent)content)) {
            String requestMode = request.getMethod();
            content.setRequestMode(requestMode);
        }
        ProcessParamUtil.initTraceId((ProcessContent)content);
    }

    protected void checkContentSecurity(ProcessContent content) throws BizException {
        String output;
        Map request = content.getRequest();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry aMap : request.entrySet()) {
            Object value;
            String key = (String)aMap.getKey();
            if ("tempContext".equals(key)) {
                Map temp = (Map)aMap.getValue();
                for (Map.Entry aTemp : temp.entrySet()) {
                    Object tempValue = aTemp.getValue();
                    if (!this.needCheck(tempValue)) continue;
                    sb.append(tempValue);
                }
            }
            if (!this.needCheck(value = aMap.getValue())) continue;
            sb.append(value);
        }
        String input = sb.toString();
        if (!input.equals(output = this.htmlFilterUtil.filter(input))) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "have_unsafe_param");
        }
    }

    private boolean needCheck(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String str = (String)value;
        return !NumberUtils.isNumeric((String)str);
    }

    private void initParams(HttpServletRequest request, ProcessContent content) throws BizException {
        Map params = request.getParameterMap();
        for (Map.Entry aMap : params.entrySet()) {
            String stringVal;
            String[] value;
            String key = (String)aMap.getKey();
            if (ProcessCheckUtil.isKeyWord((String)key) || (value = (String[])aMap.getValue()) == null || value.length == 0) continue;
            Object aValue = null;
            aValue = value.length == 1 ? value[0] : Arrays.asList((Object[])value);
            if (aValue instanceof String && !(stringVal = (String)aValue).startsWith("[") && !stringVal.startsWith("{") && StringUtil.isInvalidCharacter((String)stringVal)) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, key);
            }
            content.putRequest(key, aValue);
        }
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headKey = (String)headers.nextElement();
            String headValue = request.getHeader(headKey);
            if (!StringUtil.isNotBlank((String)headValue)) continue;
            content.putHeader(headKey, (Object)headValue);
        }
        if (content.getHeader() != null) {
            content.putTempContent("headers", (Object)content.getHeader());
        }
    }

    private List<String> cellsModuleCode() {
        ArrayList<String> moduleCodeList = new ArrayList<String>();
        moduleCodeList.add("saveModuleChartTemp");
        moduleCodeList.add("publishModule");
        return moduleCodeList;
    }
}

