/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.baseModule.init;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcode.log.ManateeLoggerManager;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component(value="initBaseTable")
public class InitBaseTable {
    @Resource
    private BaseModuleUtil baseModuleUtil;
    @Resource
    private ManateeConfig manateeConfig;
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;

    @PostConstruct
    public void initBaseTable() {
        String configDataSourceTypeNew = this.manateeConfig.getConfigData().getSourceType();
        String configDataSourcePath = this.manateeConfig.getConfigData().getSourcePath();
        String configDataSourceType = this.manateeConfig.getConfigDataSourceType();
        if (StringUtil.isNotBlank((String)configDataSourceType) && StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceType) || StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceTypeNew)) {
            try {
                if (StrUtil.isNotBlank((CharSequence)configDataSourcePath)) {
                    File moduleFile = new File(configDataSourcePath + "lowcodeBaseModules");
                    BaseModuleUtil.getAllCustomConf(moduleFile, BaseModuleUtil.getCUSTOM_PROCESS_CONF_MAP());
                    File projectFile = new File(configDataSourcePath + "lowcodeProjectConf");
                    BaseModuleUtil.getAllCustomConf(projectFile, BaseModuleUtil.getCUSTOM_PROJECT_CONF_MAP());
                }
                org.springframework.core.io.Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath:lowcodeBaseModules/*.json");
                BaseModuleUtil.getAllCustomConf(resources, BaseModuleUtil.getCUSTOM_PROCESS_CONF_MAP());
                org.springframework.core.io.Resource[] processConfResource = new PathMatchingResourcePatternResolver().getResources("classpath:lowcodeProjectConf/*.json");
                BaseModuleUtil.getAllCustomConf(processConfResource, BaseModuleUtil.getCUSTOM_PROJECT_CONF_MAP());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!this.baseModuleUtil.isExistTable("lowcode_base_module")) {
                this.baseModuleUtil.initBaseTable("lowcode_base_module");
            }
            if (!this.baseModuleUtil.isExistTable("lowcode_project_conf")) {
                this.baseModuleUtil.initBaseTable("lowcode_project_conf");
            }
            String lowcodeBaseModuleHistory = "lowcode_base_module_history";
            if (this.defaultDatabaseProductName.equals("dameng")) {
                lowcodeBaseModuleHistory = "LOWCODE_BASE_MODULE_HISTORY";
            }
            if (!this.baseModuleUtil.isExistTable(lowcodeBaseModuleHistory)) {
                this.baseModuleUtil.initBaseTable("lowcode_base_module_history");
            }
        }
        this.baseModuleUtil.getAllBaseModule();
        ManateeLoggerManager.createManateeAppender();
    }
}

