/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.tenant.manager;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.tenant.ManateeTenantServiceImpl;
import com.manatee.lowcodedb.newdb.tenant.TenantMultipleColumnService;
import com.manatee.lowcodedb.newdb.tenant.TenantService;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantManager {
    @Autowired(required=false)
    private TenantService tenantService;
    @Autowired(required=false)
    private TenantMultipleColumnService tenantMultipleColumnService;
    @Resource
    private ManateeTenantServiceImpl manateeTenantServiceImpl;

    public void addTenantToEntity(ProcessContent processContent, DbEntity entity) {
        String tableName = entity.getTableName();
        String[] split = tableName.split("\\.");
        if (split.length > 1) {
            tableName = split[1];
        }
        if (this.tenantService == null || StrUtil.isBlank((CharSequence)this.tenantService.tableColumnName()) || StrUtil.isBlank((CharSequence)this.tenantService.contentParams())) {
            if (this.tenantMultipleColumnService != null) {
                List<String> columns = this.tenantMultipleColumnService.tableColumnName();
                List<String> properties = this.tenantMultipleColumnService.properties();
                if (CollUtil.isEmpty(columns) || CollUtil.isEmpty(properties)) {
                    return;
                }
                for (int i = 0; i < columns.size(); ++i) {
                    String colum = columns.get(i);
                    Object value = processContent.getValue(properties.get(i));
                    if (value == null) {
                        return;
                    }
                    entity.set(tableName + '.' + colum, value);
                }
                return;
            }
            if (this.manateeTenantServiceImpl != null) {
                List<String> columns = this.manateeTenantServiceImpl.tableColumnName();
                List<String> properties = this.manateeTenantServiceImpl.properties();
                if (CollUtil.isEmpty(columns) || CollUtil.isEmpty(properties)) {
                    return;
                }
                for (int i = 0; i < columns.size(); ++i) {
                    String colum = columns.get(i);
                    Object value = processContent.getValue(properties.get(i));
                    if (value == null) {
                        return;
                    }
                    entity.set(tableName + '.' + colum, value);
                }
                return;
            }
            return;
        }
        Object value = processContent.getValue(this.tenantService.contentParams());
        if (value == null) {
            return;
        }
        entity.set(tableName + '.' + this.tenantService.tableColumnName(), value);
    }

    public void addTenantIsolation(List<String> tableColumnName, List<String> properties) {
        this.manateeTenantServiceImpl.addTableColumnName(tableColumnName);
        this.manateeTenantServiceImpl.addProperties(properties);
    }
}

