/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.domain.In;
import com.manatee.common.domain.Page;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.JSONUtils;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.RegexUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.base.DBWriteUtil;
import com.manatee.lowcodedb.base.MybatisXml2SqlParser;
import com.manatee.lowcodedb.constant.MySqlFunUtils;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.handle.DBHandleUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.execute.DebugUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DBManager
implements IDBManager {
    private Logger log = LoggerFactory.getLogger(DBManager.class);
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DBWriteUtil dbWriteUtil;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private DBHandleUtil dbHandleUtil;
    private static int DEFAULT_DB = 6;

    public static int getRedisDB(ProcessContent content) {
        Object db = content.getStepConf("db");
        if (db == null) {
            return DEFAULT_DB;
        }
        if (db instanceof String) {
            return Integer.valueOf(db + "");
        }
        return (Integer)db;
    }

    public Map<String, Object> getInsertParams(ProcessContent content) throws BizException {
        return this.inputUtil.getHandleObject(content, "insertParams");
    }

    public Map<String, Object> getUpdateParams(ProcessContent content) throws BizException {
        return this.inputUtil.getHandleObject(content, "updateParams");
    }

    public Map<String, Object> getUpdateParamsV2(ProcessContent content, String syntaxType) throws BizException {
        return this.inputUtil.getHandleObjectV2(content, "updateParams", syntaxType);
    }

    public Map<String, Object> getQueryParams(ProcessContent content) throws BizException {
        return this.inputUtil.getHandleObject(content, "queryParams");
    }

    public List<Map> getInsertListParams(ProcessContent content) throws BizException {
        return this.inputUtil.getHandleListObject(content, "insertParamsArray", "fieldValue");
    }

    public List<Map> getUpdateListParams(ProcessContent content) throws BizException {
        return this.inputUtil.getHandleListObject(content, "updateParamsArray", "fieldValue");
    }

    public List<Map> getQueryListParams(ProcessContent content) throws BizException {
        return this.inputUtil.getHandleListObject(content, "queryParamsArray", "fieldValue");
    }

    public List<Map> getQueryListParamsV2(ProcessContent content, String syntaxType) throws BizException {
        return this.inputUtil.getHandleListObjectV2(content, "queryParamsArray", "fieldValue", syntaxType);
    }

    public DBQuery getDBQuery(ProcessContent content, String databaseProductName) throws BizException {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(databaseProductName);
        Object selectOneData = content.getStepConf().get((Object)"selectOne");
        Object selectTotalCountData = content.getStepConf().get((Object)"selectTotalCount");
        Object camelCaseData = content.getStepConf().get((Object)"camelCase");
        Object upperOrLowerCaseData = content.getStepConf().get((Object)"upperOrLowerCase");
        Object sqlType = content.getStepConf().get((Object)"sqlType");
        Object manateeProcessVersion = content.getStepConf().get((Object)"manateeProcessVersion");
        JSONArray inData = this.in(content);
        this.sort(content, dbQuery);
        this.join(content, dbQuery);
        this.cascade(content, dbQuery);
        this.selectOne(selectOneData, dbQuery);
        this.selectTotalCount(selectTotalCountData, dbQuery);
        this.camelCase(camelCaseData, dbQuery);
        this.upperOrLowerCase(upperOrLowerCaseData, dbQuery);
        this.sqlType(sqlType, dbQuery);
        this.manateeProcessVersion(manateeProcessVersion, dbQuery);
        String db = this.variableUtil.calVarInConf(content, "db");
        if (StringUtil.isNotBlank((String)db)) {
            dbQuery.setDb(db);
        }
        String table = this.variableUtil.calVarInConf(content, "table");
        dbQuery.setTable(table);
        Map<String, Object> conditionMap = this.getQueryParams(content);
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
        conditionMap = dbHandle.initParamsSql(conditionMap, db, table);
        String condition = content.getStepConf().getString("condition");
        condition = this.handleSqlCondition(content, condition);
        dbQuery.setCondition(condition);
        dbQuery.setConditionMap(conditionMap);
        String columns = this.variableUtil.calVarInConf(content, "columns");
        if (StringUtil.isNotBlank((String)columns)) {
            dbQuery.setColumns(columns);
        }
        String sql = this.sql(content);
        dbQuery.setSql(sql);
        this.page(content, dbQuery);
        this.in(inData, dbQuery);
        return dbQuery;
    }

    public DBUpdate getDBUpdate(ProcessContent content, String databaseProductName) throws BizException {
        DBUpdate update = new DBUpdate();
        update.setDatabaseProductName(databaseProductName);
        String table = this.variableUtil.calVarInConf(content, "table");
        String db = this.variableUtil.calVarInConf(content, "db");
        Map<String, Object> queryParam = this.getQueryParams(content);
        int valueSize = queryParam.size();
        for (Object value : queryParam.values()) {
            if (value != null) continue;
            --valueSize;
        }
        JSONArray in = this.in(content);
        String condition = content.getStepConf().getString("condition");
        condition = this.handleSqlCondition(content, condition);
        if ((queryParam == null || valueSize == 0) && in == null && StringUtil.isBlank((String)condition)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "input_db_query_is_null");
        }
        Map<String, Object> updateParams = this.getUpdateParams(content);
        if (updateParams == null || updateParams.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "update_data_is_null");
        }
        update.setTable(table);
        update.setDb(db);
        update.setQueryCondition(queryParam);
        update.setUpdateColumns(updateParams);
        update.setCondition(condition);
        this.in(in, update);
        return update;
    }

    private void upperOrLowerCase(Object upperOrLowerCaseData, DBQuery dbQuery) {
        if (upperOrLowerCaseData == null) {
            return;
        }
        dbQuery.setUpperOrLowerCase(upperOrLowerCaseData.toString());
    }

    public String sql(ProcessContent content) throws BizException {
        String sql;
        String originalSql = content.getStepConf().getString("sql");
        if (StringUtil.isBlank((String)originalSql)) {
            return "";
        }
        if ((originalSql = originalSql.trim()).indexOf("</") != -1 && originalSql.indexOf(">") != -1 || originalSql.indexOf("#{") != -1 && originalSql.indexOf("}") != -1) {
            try {
                Map tempContext = (Map)content.getRequest().get("tempContext");
                HashMap<String, Object> param = new HashMap<String, Object>();
                Long manateeProcessVersion = content.getStepConf().getLong("manateeProcessVersion");
                if (manateeProcessVersion != null && manateeProcessVersion >= 410050100L && content.getHeader() != null) {
                    param.putAll(content.getHeader());
                }
                param.putAll(content.getRequest());
                param.putAll(tempContext);
                if (content.getTemp() != null) {
                    param.putAll(content.getTemp());
                }
                param.remove("tempContext");
                param.remove("cells");
                if (manateeProcessVersion != null && manateeProcessVersion >= 404010200L) {
                    ArrayList<Object> paramValues = new ArrayList<Object>();
                    HashMap<Integer, JSONObject> outParams = new HashMap<Integer, JSONObject>();
                    sql = MybatisXml2SqlParser.getSqlV2(originalSql, param, paramValues, outParams);
                    content.getStepConf().put("manateeSqlProcessParamValues", paramValues);
                    content.getStepConf().put("manateeSqlProcessOutParams", outParams);
                }
                sql = MybatisXml2SqlParser.getSql(originalSql, param);
            }
            catch (Exception e) {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
        } else {
            String whereFunction = RegexUtils.get((String)"where\\((.*)\\)", (CharSequence)originalSql, (int)1);
            if (StringUtil.isNotBlank((String)whereFunction)) {
                String handledCondition = this.handleSqlCondition(content, whereFunction);
                String handledConditionSql = StringUtil.isNotBlank((String)handledCondition) ? originalSql.replace("where(" + whereFunction + ")", "where " + handledCondition) : originalSql.replace("where(" + whereFunction + ")", "");
                content.getStepConf().put("sql", (Object)handledConditionSql);
            }
            sql = this.variableUtil.calVarInConf(content, "sql");
            sql = sql.replaceAll("[\r\n\t]", " ");
        }
        return sql;
    }

    public void camelCase(Object camelCaseData, DBQuery dbQuery) {
        if (camelCaseData == null) {
            return;
        }
        Boolean camelCase = Boolean.valueOf(camelCaseData.toString());
        dbQuery.setCamelCase(camelCase);
    }

    public JSONArray in(ProcessContent content) throws BizException {
        String inStr = content.getStepConf().getString("in");
        JSONArray result = new JSONArray();
        if (StringUtil.isNotBlank((String)inStr)) {
            boolean filterEmptyInValue = true;
            if (content.getStepConf().containsKey((Object)"filterEmptyInValue")) {
                filterEmptyInValue = content.getStepConf().getBoolean("filterEmptyInValue");
            }
            JSONObject inData = this.getInJsonObject(content, inStr, filterEmptyInValue);
            result.add((Object)inData);
            return result;
        }
        JSONArray inArray = content.getStepConf().getJSONArray("inArray");
        if (inArray == null || inArray.size() == 0) {
            return result;
        }
        for (Object in : inArray) {
            JSONObject inJsonObj;
            String string;
            if (in == null || StringUtil.isBlank((String)(string = (inJsonObj = (JSONObject)in).getString("in")))) continue;
            if (inJsonObj.containsKey((Object)"filterEmptyInValue")) {
                String filterEmptyInValue = inJsonObj.getString("filterEmptyInValue");
                JSONObject inData = this.getInJsonObject(content, string, filterEmptyInValue.equals("true"));
                result.add((Object)inData);
                continue;
            }
            JSONObject inData = this.getInJsonObject(content, string, true);
            inData.put("filterEmptyInValue", (Object)true);
            if (inData.isEmpty()) continue;
            result.add((Object)inData);
        }
        return result;
    }

    private JSONObject getInJsonObject(ProcessContent content, String inStr, boolean filterEmptyInValue) throws BizException {
        JSONObject in = JSONUtils.isJson((String)inStr) ? JSONObject.parseObject((String)inStr) : new JSONObject(this.inputUtil.getHandleMapConf(content, (Object)inStr));
        JSONObject inData = new JSONObject(true);
        if (in == null) {
            return inData;
        }
        String key = in.getString("key");
        inData.put("filterEmptyInValue", (Object)filterEmptyInValue);
        if (StringUtil.isBlank((String)in.getString("value")) || StringUtil.isBlank((String)key)) {
            inData.put("key", (Object)key);
            inData.put("value", new ArrayList());
            return inData;
        }
        inData.put("key", (Object)key);
        Object value = JSONUtils.isJson((String)inStr) ? content.getValue(in.getString("value")) : in.get((Object)"value");
        inData.put("value", value);
        String valueKey = in.getString("valueKey");
        inData.put("valueKey", (Object)valueKey);
        return inData;
    }

    public void sort(ProcessContent content, DBQuery dbQuery) throws BizException {
        String sortStr = content.getStepConf().getString("sort");
        if (StringUtil.isBlank((String)sortStr)) {
            return;
        }
        JSONObject sort = JSONUtils.isJson((String)sortStr) ? content.getStepConf().getJSONObject("sort") : new JSONObject(this.inputUtil.getHandleObject(content, "sort"));
        if (sort == null) {
            return;
        }
        JSONObject sortData = new JSONObject(true);
        for (String key : sort.keySet()) {
            String value = sort.getString(key);
            if (value.contains("${")) {
                value = this.variableUtil.calVar(content, value);
            }
            if (key.contains("${")) {
                key = this.variableUtil.calVar(content, key);
            }
            sortData.put(key, (Object)value);
        }
        dbQuery.setSort((Map)sortData);
    }

    public String handleSqlCondition(ProcessContent content, String condition) {
        if (StringUtil.isBlank((String)condition)) {
            return "";
        }
        condition = condition.replaceAll("[\r\n\t]", " ");
        String conditionInner = RegexUtils.get((String)"\\((.*?)\\)", (CharSequence)condition, (int)1);
        ArrayList<String> handledInnerStrList = new ArrayList<String>();
        while (StringUtil.isNotBlank((String)conditionInner)) {
            conditionInner = "(" + conditionInner + ")";
            condition = condition.replace(conditionInner, "?");
            conditionInner = this.initSqlConditionAndOr(content, conditionInner);
            handledInnerStrList.add(conditionInner);
            conditionInner = RegexUtils.get((String)"\\((.*?)\\)", (CharSequence)condition, (int)1);
        }
        for (String innerHandledStr : handledInnerStrList) {
            if (StringUtil.isNotBlank((String)innerHandledStr)) {
                if (innerHandledStr.contains("(") && innerHandledStr.contains(")")) {
                    innerHandledStr = RegexUtils.get((String)"\\((.*?)\\)", (CharSequence)innerHandledStr, (int)1);
                }
                condition = condition.replaceFirst("\\?", "(" + innerHandledStr + ")");
                continue;
            }
            condition = condition.replaceFirst("\\?", " 1=1 ");
        }
        condition = this.initSqlConditionAndOr(content, condition);
        return condition;
    }

    private String initSqlConditionAndOr(ProcessContent content, String condition) {
        if (condition.indexOf(" or ") != -1) {
            condition = this.initSqlCondition(content, condition, "or");
        } else if (condition.indexOf(" OR ") != -1) {
            condition = this.initSqlCondition(content, condition, "OR");
        } else if (condition.indexOf(" and ") != -1) {
            condition = this.initSqlCondition(content, condition, "and");
        } else if (condition.indexOf(" AND ") != -1) {
            condition = this.initSqlCondition(content, condition, "AND");
        } else {
            String param = RegexUtils.get((String)"\\$\\{(.*?)\\}", (CharSequence)condition, (int)1);
            if (StringUtil.isNotBlank((String)param)) {
                Object value = content.getValue(param);
                if (value != null && StringUtil.isNotBlank((String)value.toString())) {
                    String valueStr = value.toString();
                    if (!valueStr.contains("%") && (condition.contains(" like ") || condition.contains(" LIKE "))) {
                        valueStr = "%" + valueStr + "%";
                    }
                    if (value instanceof String) {
                        if ((condition = condition.replace("${" + param + "}", "'" + valueStr + "'")).startsWith("(") && condition.endsWith(")")) {
                            condition = condition.substring(1, condition.length() - 1);
                        }
                    } else if (value instanceof List) {
                        List valueList = (List)value;
                        if (valueList.size() > 0) {
                            StringBuilder listSb = new StringBuilder();
                            listSb.append("(");
                            for (Object object : valueList) {
                                if (object instanceof String) {
                                    listSb.append("'").append(object).append("',");
                                    continue;
                                }
                                listSb.append(object).append(",");
                            }
                            listSb.deleteCharAt(listSb.length() - 1);
                            listSb.append(")");
                            condition = condition.replace("${" + param + "}", listSb.toString());
                            if (condition.startsWith("(") && condition.endsWith(")")) {
                                condition = condition.substring(1, condition.length() - 1);
                            }
                        }
                    } else if ((condition = condition.replace("${" + param + "}", valueStr)).startsWith("(") && condition.endsWith(")")) {
                        condition = condition.substring(1, condition.length() - 1);
                    }
                } else if (condition.startsWith("(") && condition.endsWith(")")) {
                    condition = condition.replace("${" + param + "}", "''");
                    condition = condition.substring(1, condition.length() - 1);
                } else {
                    condition = null;
                }
            }
        }
        return condition;
    }

    private String initSqlCondition(ProcessContent content, String condition, String symbol) {
        String[] conditionArray;
        StringBuilder conditionSb = new StringBuilder();
        String symbolStr = " " + symbol + " ";
        for (String conditionSingle : conditionArray = condition.split(symbolStr)) {
            String param = RegexUtils.get((String)"\\$\\{(.*?)\\}", (CharSequence)conditionSingle, (int)1);
            if (StringUtil.isNotBlank((String)param)) {
                Object value = content.getValue(param);
                if (value == null || !StringUtil.isNotBlank((String)value.toString())) continue;
                String valueStr = value.toString();
                String fun = RegexUtils.get((String)" (\\S*) \\(", (CharSequence)condition, (int)1);
                boolean isFun = MySqlFunUtils.isFun(fun);
                if (!valueStr.contains("%") && !isFun && (conditionSingle.contains(" like ") || conditionSingle.contains(" LIKE "))) {
                    valueStr = "%" + valueStr + "%";
                }
                if (value instanceof String) {
                    conditionSingle = conditionSingle.replace("${" + param + "}", "'" + valueStr + "'");
                } else if (value instanceof List) {
                    List valueList = (List)value;
                    if (valueList.size() > 0) {
                        StringBuilder listSb = new StringBuilder();
                        listSb.append("(");
                        for (Object object : valueList) {
                            if (object instanceof String) {
                                listSb.append("'").append(object).append("',");
                                continue;
                            }
                            listSb.append(object).append(",");
                        }
                        listSb.deleteCharAt(listSb.length() - 1);
                        listSb.append(")");
                        conditionSingle = conditionSingle.replace("${" + param + "}", listSb.toString());
                    }
                } else {
                    conditionSingle = conditionSingle.replace("${" + param + "}", valueStr);
                }
                conditionSb.append(conditionSingle).append(symbolStr);
                continue;
            }
            conditionSb.append(conditionSingle).append(symbolStr);
        }
        if (conditionSb.indexOf(symbolStr) != -1) {
            conditionSb = new StringBuilder(conditionSb.substring(0, conditionSb.length() - symbolStr.length()));
        }
        return conditionSb.toString();
    }

    public void selectTotalCount(Object selectTotalCount, DBQuery dbQuery) {
        if (selectTotalCount == null) {
            return;
        }
        dbQuery.setSelectTotalCount(Boolean.valueOf(Boolean.parseBoolean(selectTotalCount.toString())));
    }

    public void selectOne(Object selectOne, DBQuery dbQuery) {
        if (selectOne == null) {
            return;
        }
        dbQuery.setSelectOne(Boolean.valueOf(Boolean.parseBoolean(selectOne.toString())));
    }

    public void sqlType(Object sqlType, DBQuery dbQuery) {
        if (sqlType == null) {
            return;
        }
        dbQuery.setSqlType(sqlType.toString());
    }

    public void manateeProcessVersion(Object manateeProcessVersion, DBQuery dbQuery) {
        if (manateeProcessVersion != null) {
            dbQuery.setManateeProcessVersion(Long.valueOf(Long.parseLong(manateeProcessVersion.toString())));
        } else {
            dbQuery.setManateeProcessVersion(null);
        }
    }

    public void join(ProcessContent content, DBQuery dbQuery) throws BizException {
        Object join = content.getStepConf().get((Object)"join");
        if (join == null) {
            return;
        }
        JSONArray joinJsonArr = JSONArray.parseArray((String)JSON.toJSONString((Object)join));
        for (int i = 0; i < joinJsonArr.size(); ++i) {
            String condition;
            JSONObject joinJson = joinJsonArr.getJSONObject(i);
            String joinQueryParamsStr = joinJson.getString("queryParams");
            Map joinQueryMap = JSONUtils.isJson((String)joinQueryParamsStr) ? this.inputUtil.getHandleMapConf(content, (Object)joinJson.getJSONObject("queryParams")) : this.inputUtil.getHandleMapConf(content, (Object)joinQueryParamsStr);
            if (joinQueryMap == null) {
                joinQueryMap = new HashMap();
            }
            JSONObject joinQueryParams = new JSONObject(joinQueryMap);
            if (joinJson.getString("columns") != null && !joinJson.getString("columns").isEmpty()) {
                String columnStr = this.columnStrRemoveSpace(joinJson.getString("columns"));
                joinJson.put("columns", (Object)columnStr);
            }
            if (StringUtil.isNotBlank((String)(condition = joinJson.getString("condition")))) {
                condition = condition.indexOf(" or ") != -1 ? this.initSqlCondition(content, condition, "or") : this.initSqlCondition(content, condition, "and");
                joinQueryParams.put("condition", (Object)condition);
            }
            joinJson.put("queryParams", (Object)joinQueryParams);
            if (!joinJson.containsKey((Object)"queryParamsArray")) continue;
            String syntaxType = joinJson.getString("syntaxTypeJoin");
            List joinQueryParamsArray = this.inputUtil.getHandleListObjectV2(content, "fieldValue", joinJson.get((Object)"queryParamsArray"), syntaxType);
            joinJson.put("queryParamsArray", (Object)joinQueryParamsArray);
        }
        dbQuery.setJoin(joinJsonArr);
    }

    public String columnStrRemoveSpace(String str) {
        List<String> columnsList = Arrays.asList(str.split(","));
        ArrayList<String> list = new ArrayList<String>();
        for (int j = 0; j < columnsList.size(); ++j) {
            String column = columnsList.get(j).trim();
            list.add(column);
        }
        return StringUtils.join((Object[])list.toArray(), (String)",");
    }

    public void cascade(ProcessContent content, DBQuery dbQuery) throws BizException {
        Object cascade = content.getStepConf().get((Object)"cascade");
        if (cascade == null) {
            return;
        }
        JSONArray cascadeJsonArr = JSONArray.parseArray((String)JSON.toJSONString((Object)cascade));
        for (int i = 0; i < cascadeJsonArr.size(); ++i) {
            JSONObject cascadeJson = cascadeJsonArr.getJSONObject(i);
            String joinQueryParamsStr = cascadeJson.getString("queryParams");
            Map cascadeQueryMap = JSONUtils.isJson((String)joinQueryParamsStr) ? this.inputUtil.getHandleMapConf(content, (Object)cascadeJson.getJSONObject("queryParams")) : this.inputUtil.getHandleMapConf(content, (Object)joinQueryParamsStr);
            if (cascadeQueryMap == null) {
                cascadeQueryMap = new HashMap();
            }
            JSONObject cascadeQueryParams = new JSONObject(cascadeQueryMap);
            String condition = cascadeJson.getString("condition");
            if (StringUtil.isNotBlank((String)condition)) {
                condition = condition.indexOf(" or ") != -1 ? this.initSqlCondition(content, condition, "or") : this.initSqlCondition(content, condition, "and");
                cascadeQueryParams.put("condition", (Object)condition);
            }
            cascadeJson.put("queryParams", (Object)cascadeQueryParams);
            if (!cascadeJson.containsKey((Object)"queryParamsArray")) continue;
            String syntaxType = cascadeJson.getString("syntaxTypeCascade");
            List cascadeQueryParamsArray = this.inputUtil.getHandleListObjectV2(content, "fieldValue", cascadeJson.get((Object)"queryParamsArray"), syntaxType);
            cascadeJson.put("queryParamsArray", (Object)cascadeQueryParamsArray);
        }
        dbQuery.setCascade(cascadeJsonArr);
    }

    public void page(ProcessContent content, DBQuery dbQuery) throws BizException {
        String pageNumStr = this.variableUtil.calVarInConf(content, "pageNum");
        String pageSizeStr = this.variableUtil.calVarInConf(content, "pageSize");
        String pageOrderColumns = this.variableUtil.calVarInConf(content, "pageOrderColumns");
        String pageType = this.variableUtil.calVarInConf(content, "pageType");
        if (StringUtil.isBlank((String)pageNumStr) && StringUtil.isBlank((String)pageSizeStr)) {
            return;
        }
        Page page = new Page();
        Integer pageNum = null;
        Integer pageSize = null;
        if (StringUtil.isNotBlank((String)pageNumStr)) {
            if (!NumberUtils.isNumber((String)pageNumStr)) {
                Object pageNumObj = content.getValue(pageNumStr);
                if (pageNumObj == null) {
                    throw new BizException(ResultCode.PARAM_IS_ERROR, "pageNum\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                pageNumStr = pageNumObj.toString();
            }
            try {
                pageNum = Integer.valueOf(pageNumStr);
            }
            catch (Exception e) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "pageNum\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (StringUtil.isNotBlank((String)pageSizeStr)) {
            if (!NumberUtils.isNumber((String)pageSizeStr)) {
                Object pageSizeObj = content.getValue(pageSizeStr);
                if (pageSizeObj == null) {
                    throw new BizException(ResultCode.PARAM_IS_ERROR, "pageSize\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                }
                pageSizeStr = pageSizeObj.toString();
            }
            try {
                pageSize = Integer.valueOf(pageSizeStr);
            }
            catch (Exception e) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "pageSize\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (StringUtil.isNotBlank((String)pageOrderColumns)) {
            page.setPageOrderColumns(pageOrderColumns);
        } else {
            page.setPageOrderColumns("id");
        }
        if (StringUtil.isNotBlank((String)pageType)) {
            page.setPageType(pageType);
        }
        page.setPageNum(pageNum);
        if (pageSize == null) {
            pageSize = 20;
        }
        page.setPageSize(pageSize);
        dbQuery.setPage(page);
    }

    public void in(JSONArray inConf, DBQuery dbQuery) {
        if (inConf == null || inConf.size() == 0) {
            return;
        }
        ArrayList<In> inList = new ArrayList<In>(inConf.size());
        for (Object inObj : inConf) {
            JSONObject inJson = (JSONObject)inObj;
            In in = new In();
            String key = inJson.getString("key");
            in.setKey(key);
            List<Object> value = (ArrayList)inJson.get((Object)"value");
            if (value == null) {
                value = new ArrayList();
            }
            String valueKey = inJson.getString("valueKey");
            List<Object> newValue = new ArrayList();
            if (StringUtil.isNotBlank((String)valueKey)) {
                for (Object object : value) {
                    if (!(object instanceof Map)) continue;
                    Map map = (Map)object;
                    Object newObj = map.get(valueKey);
                    newValue.add(newObj);
                }
                newValue = newValue.stream().distinct().collect(Collectors.toList());
                in.setValue(newValue);
            } else {
                value = value.stream().distinct().collect(Collectors.toList());
                in.setValue(value);
            }
            boolean filterEmptyInValue = inJson.getBoolean("filterEmptyInValue");
            in.setFilterEmptyValue(filterEmptyInValue);
            inList.add(in);
        }
        dbQuery.setIn(inList);
    }

    public void in(JSONArray inConf, DBQuery dbQuery, Boolean isFilter) {
        if (isFilter == null) {
            isFilter = true;
        }
        if (isFilter.booleanValue() && (inConf == null || inConf.size() == 0)) {
            return;
        }
        if (inConf == null) {
            inConf = new JSONArray();
        }
        ArrayList<In> inList = new ArrayList<In>(inConf.size());
        for (Object inObj : inConf) {
            JSONObject inJson = (JSONObject)inObj;
            In in = new In();
            String key = inJson.getString("key");
            in.setKey(key);
            List<Object> value = (ArrayList)inJson.get((Object)"value");
            if (value == null) {
                value = new ArrayList();
            }
            String valueKey = inJson.getString("valueKey");
            List<Object> newValue = new ArrayList();
            if (StringUtil.isNotBlank((String)valueKey)) {
                for (Object object : value) {
                    if (!(object instanceof Map)) continue;
                    Map map = (Map)object;
                    Object newObj = map.get(valueKey);
                    newValue.add(newObj);
                }
                newValue = newValue.stream().distinct().collect(Collectors.toList());
                in.setValue(newValue);
            } else {
                value = value.stream().distinct().collect(Collectors.toList());
                in.setValue(value);
            }
            boolean filterEmptyInValue = inJson.getBoolean("filterEmptyInValue");
            in.setFilterEmptyValue(filterEmptyInValue);
            inList.add(in);
        }
        dbQuery.setIn(inList);
    }

    public void in(JSONArray inConf, DBUpdate dbUpdate) {
        if (inConf == null || inConf.size() == 0) {
            return;
        }
        ArrayList<In> inList = new ArrayList<In>(inConf.size());
        for (Object inObj : inConf) {
            JSONObject inJson = (JSONObject)inObj;
            In in = new In();
            String key = inJson.getString("key");
            in.setKey(key);
            List<Object> value = (ArrayList)inJson.get((Object)"value");
            if (value == null) {
                value = new ArrayList();
            }
            String valueKey = inJson.getString("valueKey");
            List<Object> newValue = new ArrayList();
            if (StringUtil.isNotBlank((String)valueKey)) {
                for (Object object : value) {
                    if (!(object instanceof Map)) continue;
                    Map map = (Map)object;
                    Object newObj = map.get(valueKey);
                    newValue.add(newObj);
                }
                newValue = newValue.stream().distinct().collect(Collectors.toList());
                in.setValue(newValue);
            } else {
                value = value.stream().distinct().collect(Collectors.toList());
                in.setValue(value);
            }
            boolean filterEmptyInValue = inJson.getBoolean("filterEmptyInValue");
            in.setFilterEmptyValue(filterEmptyInValue);
            inList.add(in);
        }
        dbUpdate.setIn(inList);
    }

    public int deleteData(ProcessContent content, String databaseProductName) throws BizException {
        int deleteCount;
        String table = this.variableUtil.calVarInConf(content, "table");
        String db = this.variableUtil.calVarInConf(content, "db");
        Map<String, Object> queryParam = this.getQueryParams(content);
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
        queryParam = dbHandle.initParamsSql(queryParam, db, table);
        int valueSize = queryParam.size();
        for (Object value : queryParam.values()) {
            if (value != null) continue;
            --valueSize;
        }
        JSONArray in = this.in(content);
        in = dbHandle.initInSql(in, db, table);
        String condition = content.getStepConf().getString("condition");
        condition = this.handleSqlCondition(content, condition);
        if ((queryParam == null || valueSize == 0) && in == null && StringUtil.isBlank((String)condition)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "input_db_query_is_null");
        }
        DBUpdate delete = new DBUpdate();
        delete.setTable(table);
        delete.setQueryCondition(queryParam);
        delete.setCondition(condition);
        this.in(in, delete);
        try {
            deleteCount = this.dbWriteUtil.delete(delete, db, content.getTransactionCon());
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            this.logExecuteSql(content, delete.getExecuteSql());
        }
        return deleteCount;
    }

    public int updateData(ProcessContent content, DBUpdate dbUpdate) throws BizException {
        int updateCount;
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbUpdate.getDatabaseProductName());
        Map<String, Object> queryParams = this.getQueryParams(content);
        int valueSize = (queryParams = dbHandle.initParamsSql(queryParams, dbUpdate.getDb(), dbUpdate.getTable())).size();
        if (valueSize == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u66f4\u65b0\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
        }
        dbUpdate.setQueryCondition(queryParams);
        Map<String, Object> updateParams = this.getUpdateParams(content);
        updateParams = dbHandle.initParamsSql(updateParams, dbUpdate.getDb(), dbUpdate.getTable());
        dbUpdate.setUpdateColumns(updateParams);
        JSONArray in = this.in(content);
        in = dbHandle.initInSql(in, dbUpdate.getDb(), dbUpdate.getTable());
        this.in(in, dbUpdate);
        try {
            updateCount = this.dbWriteUtil.update(dbUpdate, content.getTransactionCon());
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            this.logExecuteSql(content, dbUpdate.getExecuteSql());
        }
        return updateCount;
    }

    public void logExecuteSql(ProcessContent content, String sql) {
        if (StringUtil.isBlank((String)sql)) {
            return;
        }
        if (DebugUtil.isDebug((ProcessContent)content)) {
            String modulePath = "";
            if (content.getModulePathList() != null && content.getModulePathList().size() > 0) {
                modulePath = org.apache.commons.lang3.StringUtils.join((Iterable)content.getModulePathList(), (String)"==>");
                modulePath = modulePath + "==>";
            }
            JSONObject executeSqlObj = new JSONObject(true);
            executeSqlObj.put("stepName", (Object)(modulePath + content.getStep().getTitle()));
            executeSqlObj.put("executeSql", (Object)sql);
            executeSqlObj.put("nodeId", (Object)content.getStep().getId());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)modulePath)) {
                executeSqlObj.put("type", (Object)"module");
            } else {
                executeSqlObj.put("type", (Object)"step");
            }
            content.getDebug().putExecuteSqls(executeSqlObj);
        }
        this.log.warn("sql: " + sql);
    }

    public JSON executeSelectSql(ProcessContent content, DBQuery dbQuery) throws BizException {
        this.logExecuteSql(content, dbQuery.getSql());
        return this.dbReadUtil.executeSelectSql(dbQuery, content);
    }

    public JSON executeSelectSqlV2(ProcessContent content, DBQuery dbQuery) throws BizException {
        return this.dbReadUtil.executeSelectSql(dbQuery, content);
    }

    public JSON executeSelectSqlV3(ProcessContent content, DBQuery dbQuery) throws BizException {
        return this.dbReadUtil.executeSelectSqlV2(dbQuery, content);
    }

    public int executeNotSelectSql(ProcessContent content, DBQuery dbQuery) throws BizException {
        this.logExecuteSql(content, dbQuery.getSql());
        return this.dbReadUtil.executeNotSelectSql(dbQuery, content.getTransactionCon());
    }

    public int executeNotSelectSqlV2(ProcessContent content, DBQuery dbQuery) throws BizException {
        return this.dbReadUtil.executeNotSelectSqlV2(dbQuery, content.getTransactionCon(), content);
    }

    public JSON executeCallSql(ProcessContent content, DBQuery dbQuery) throws BizException {
        return this.dbReadUtil.executeCallSql(dbQuery, content);
    }

    public JSONObject querySqlTotalCount(DBQuery dbQueryForCount, ProcessContent content) throws BizException {
        Integer integer;
        if (!dbQueryForCount.getSelectTotalCount().booleanValue() || dbQueryForCount.getPage() == null) {
            return null;
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbQueryForCount.getDatabaseProductName());
        if (dbHandle == null) {
            return null;
        }
        dbHandle.initCountSql(dbQueryForCount.getSql(), dbQueryForCount);
        dbQueryForCount.setSelectOne(Boolean.valueOf(true));
        JSONObject countJson = (JSONObject)this.dbReadUtil.executeSelectSql(dbQueryForCount, content);
        Integer n = countJson.getInteger("count(*)") == null ? (countJson.getInteger("count()") == null ? countJson.getInteger("COUNT(*)") : countJson.getInteger("count()")) : (integer = countJson.getInteger("count(*)"));
        if (countJson != null && integer != null) {
            Integer totalCount = integer;
            totalCountJson.put(totalCountReturnKey, (Object)totalCount);
            Integer pageSize = dbQueryForCount.getPage().getPageSize();
            if (pageSize != null && pageSize > 0) {
                Integer totalPage = totalCount / pageSize;
                if (totalPage * pageSize < totalCount) {
                    Integer n2 = totalPage;
                    Integer n3 = totalPage = Integer.valueOf(totalPage + 1);
                }
                totalCountJson.put(totalPageReturnKey, (Object)totalPage);
            }
        }
        return totalCountJson;
    }

    public JSONObject insertData(ProcessContent content, String databaseProductName) throws BizException {
        JSONObject insertResult;
        Map<String, Object> insertParams;
        JSONObject conf = content.getStepConf();
        String table = this.variableUtil.calVarInConf(content, "table");
        String db = this.variableUtil.calVarInConf(content, "db");
        String pkName = this.variableUtil.calVarInConf(content, "pkName");
        String handleType = content.getStepConfString("handleType");
        String insertType = content.getStepConfString("insertType");
        DBInsert insert = new DBInsert();
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
        if ("batch".equals(handleType)) {
            if (!conf.containsKey((Object)"paramsKey")) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "paramsKey_is_null");
            }
            insertParams = this.getInsertParams(content);
            List<Map<String, Object>> insertParamsObject = (List<Map<String, Object>>)this.inputUtil.getHandleData(content, "insertParams");
            insert.setBatch(true);
            insertParamsObject = dbHandle.initListParamsSql(insertParamsObject, db, table);
            insert.setInsertColumnsBatch(insertParamsObject);
        } else {
            insertParams = this.getInsertParams(content);
            if (insertParams == null || insertParams.size() == 0) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "insert_data_is_null");
            }
        }
        insertParams = dbHandle.initParamsSql(insertParams, db, table);
        insert.setInsertColumns(insertParams);
        insert.setTable(table);
        insert.setPkName(pkName);
        insert.setDatabaseProductName(databaseProductName);
        insert.setInsertType(insertType);
        try {
            insertResult = this.dbWriteUtil.insert(insert, db, content.getTransactionCon());
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            this.logExecuteSql(content, insert.getExecuteSql());
        }
        JSONObject insertJson = new JSONObject();
        dbHandle.composeInsertResult(insert, content, insertResult, this.outputUtil);
        return insertJson;
    }
}

