/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.http.server;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.map.CaseInsensitiveMap;
import com.manatee.common.util.tool.core.map.multi.ListValueMap;
import com.manatee.common.util.tool.core.net.NetUtil;
import com.manatee.common.util.tool.core.net.multipart.MultipartFormData;
import com.manatee.common.util.tool.core.net.multipart.UploadSetting;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.http.Header;
import com.manatee.common.util.tool.http.HttpUtil;
import com.manatee.common.util.tool.http.Method;
import com.manatee.common.util.tool.http.server.HttpServerBase;
import com.manatee.common.util.tool.http.useragent.UserAgent;
import com.manatee.common.util.tool.http.useragent.UserAgentUtil;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class HttpServerRequest
extends HttpServerBase {
    private Map<String, HttpCookie> cookieCache;
    private ListValueMap<String, String> paramsCache;
    private MultipartFormData multipartFormDataCache;
    private Charset charsetCache;
    private byte[] bodyCache;

    public HttpServerRequest(HttpExchange httpExchange) {
        super(httpExchange);
    }

    public String getMethod() {
        return this.httpExchange.getRequestMethod();
    }

    public boolean isGetMethod() {
        return Method.GET.name().equalsIgnoreCase(this.getMethod());
    }

    public boolean isPostMethod() {
        return Method.POST.name().equalsIgnoreCase(this.getMethod());
    }

    public URI getURI() {
        return this.httpExchange.getRequestURI();
    }

    public String getPath() {
        return this.getURI().getPath();
    }

    public String getQuery() {
        return this.getURI().getQuery();
    }

    public Headers getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    public String getHeader(Header headerKey) {
        return this.getHeader(headerKey.toString());
    }

    public String getHeader(String headerKey) {
        return this.getHeaders().getFirst(headerKey);
    }

    public String getHeader(String headerKey, Charset charset) {
        String header = this.getHeader(headerKey);
        if (null != header) {
            return CharsetUtil.convert(header, CharsetUtil.CHARSET_ISO_8859_1, charset);
        }
        return null;
    }

    public String getContentType() {
        return this.getHeader(Header.CONTENT_TYPE);
    }

    public Charset getCharset() {
        if (null == this.charsetCache) {
            String contentType = this.getContentType();
            String charsetStr = HttpUtil.getCharset(contentType);
            this.charsetCache = CharsetUtil.parse(charsetStr, DEFAULT_CHARSET);
        }
        return this.charsetCache;
    }

    public String getUserAgentStr() {
        return this.getHeader(Header.USER_AGENT);
    }

    public UserAgent getUserAgent() {
        return UserAgentUtil.parse(this.getUserAgentStr());
    }

    public String getCookiesStr() {
        return this.getHeader(Header.COOKIE);
    }

    public Collection<HttpCookie> getCookies() {
        return this.getCookieMap().values();
    }

    public Map<String, HttpCookie> getCookieMap() {
        if (null == this.cookieCache) {
            this.cookieCache = Collections.unmodifiableMap(CollUtil.toMap(NetUtil.parseCookies(this.getCookiesStr()), new CaseInsensitiveMap(), HttpCookie::getName));
        }
        return this.cookieCache;
    }

    public HttpCookie getCookie(String cookieName) {
        return this.getCookieMap().get(cookieName);
    }

    public boolean isMultipart() {
        if (!this.isPostMethod()) {
            return false;
        }
        String contentType = this.getContentType();
        if (StrUtil.isBlank(contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public String getBody() {
        return this.getBody(this.getCharset());
    }

    public String getBody(Charset charset) {
        return StrUtil.str(this.getBodyBytes(), charset);
    }

    public byte[] getBodyBytes() {
        if (null == this.bodyCache) {
            this.bodyCache = IoUtil.readBytes(this.getBodyStream(), true);
        }
        return this.bodyCache;
    }

    public InputStream getBodyStream() {
        return this.httpExchange.getRequestBody();
    }

    public ListValueMap<String, String> getParams() {
        if (null == this.paramsCache) {
            this.paramsCache = new ListValueMap();
            Charset charset = this.getCharset();
            String query = this.getQuery();
            if (StrUtil.isNotBlank(query)) {
                this.paramsCache.putAll(HttpUtil.decodeParams(query, charset));
            }
            if (this.isMultipart()) {
                this.paramsCache.putAll(this.getMultipart().getParamListMap());
            } else {
                String body = this.getBody();
                if (StrUtil.isNotBlank(body)) {
                    this.paramsCache.putAll(HttpUtil.decodeParams(body, charset));
                }
            }
        }
        return this.paramsCache;
    }

    public String getClientIP(String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            headers = ArrayUtil.addAll(headers, otherHeaderNames);
        }
        return this.getClientIPByHeader(headers);
    }

    public String getClientIPByHeader(String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = this.getHeader(header);
            if (NetUtil.isUnknown(ip)) continue;
            return NetUtil.getMultistageReverseProxyIp(ip);
        }
        ip = this.httpExchange.getRemoteAddress().getHostName();
        return NetUtil.getMultistageReverseProxyIp(ip);
    }

    public MultipartFormData getMultipart() throws IORuntimeException {
        if (null == this.multipartFormDataCache) {
            this.multipartFormDataCache = this.parseMultipart(new UploadSetting());
        }
        return this.multipartFormDataCache;
    }

    public MultipartFormData parseMultipart(UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream(this.getBodyStream(), this.getCharset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return formData;
    }
}

