/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.domain;

import com.alibaba.fastjson.JSON;
import com.manatee.common.util.StringUtil;
import java.util.HashMap;
import java.util.List;

public class DingdingTextMessage {
    private static final long serialVersionUID = -4395740926882079026L;
    private String text;
    private List<String> atMobiles;
    private boolean isAtAll;

    public DingdingTextMessage(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getAtMobiles() {
        return this.atMobiles;
    }

    public void setAtMobiles(List<String> atMobiles) {
        this.atMobiles = atMobiles;
    }

    public boolean isAtAll() {
        return this.isAtAll;
    }

    public void setIsAtAll(boolean isAtAll) {
        this.isAtAll = isAtAll;
    }

    public String toJsonString() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", "text");
        HashMap<String, String> textContent = new HashMap<String, String>();
        if (StringUtil.isBlank(this.text)) {
            throw new IllegalArgumentException("text should not be blank");
        }
        textContent.put("content", this.text);
        items.put("text", textContent);
        HashMap<String, Object> atItems = new HashMap<String, Object>();
        if (this.atMobiles != null && !this.atMobiles.isEmpty()) {
            atItems.put("atMobiles", this.atMobiles);
        }
        if (this.isAtAll) {
            atItems.put("isAtAll", this.isAtAll);
        }
        items.put("at", atItems);
        return JSON.toJSONString(items);
    }
}

