/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryTaskProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        String userId = this.variableUtil.calVarInConf(content, "userId");
        String processInstanceIds = this.variableUtil.calVarInConf(content, "processInstanceIds");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            taskQuery.taskAssignee(userId);
        }
        if (StrUtil.isNotBlank((CharSequence)processInstanceIds)) {
            String[] processInstanceIdsArr = processInstanceIds.split(",");
            taskQuery.processInstanceIdIn(processInstanceIdsArr);
        }
        List list = taskQuery.list();
        String jsonString = JSONUtil.toJsonStr((Object)list);
        this.outputUtil.putData(content, JSONObject.parse((String)jsonString));
    }

    public String getName() {
        return "camundaQueryTask";
    }
}

