/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisKeyIsExistsProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(RedisKeyIsExistsProcess.class);
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"key"});
        JSONObject stepConf = content.getStepConf();
        int db = RedisDbUtil.getRedisDB(content);
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        Boolean ret = this.dtSourceManager.getDtSource().exists(db, objectKey);
        if (StringUtil.isBlank((String)stepConf.getString("returnKey"))) {
            content.getStepConf().put("returnKey", (Object)(objectKey + "Exists"));
        }
        this.outputUtil.handleAndPutData(content, (Object)ret);
        this.log.warn("[RedisKeyIsExistsProcess.process]_biz_occur,msg:{}", (Object)("isExists:" + ret));
    }

    public String getName() {
        return "redisKeyIsExists";
    }
}

