CREATE TABLE `lowcode_logic_behavior_rel` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL COMMENT '项目id',
  `rel_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '关联类型，1-一对一，2-一对多',
  `main_logic_id` bigint(20) NOT NULL COMMENT '主模型ID',
  `rel_logic_id` bigint(20) NOT NULL COMMENT '关联模型ID',
  `main_logic_attr_id` bigint(20) NOT NULL COMMENT '主模型字段编码',
  `rel_behavior_id` bigint(20) NOT NULL COMMENT '关联模型行为ID',
  `rel_params` text DEFAULT NULL COMMENT '关联参数',
  `batch_status` tinyint(4) DEFAULT '0' COMMENT '批量开启状态，0-未开启，1-开启',
  `rel_batch_behavior_id` bigint(20) DEFAULT NULL COMMENT '关联批量模型行为ID',
  `create_user` bigint(20) DEFAULT NULL COMMENT '创建人',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `modified_user` bigint(20) DEFAULT NULL COMMENT '修改用户',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  `valid` tinyint(4) DEFAULT '0' COMMENT '状态:-1 删除, 0 正常',
  `ext1` varchar(64) DEFAULT NULL COMMENT '扩展字段1',
  `ext2` varchar(64) DEFAULT NULL COMMENT '扩展字段2',
  `ext3` varchar(64) DEFAULT NULL COMMENT '扩展字段3',
  `designer_id` bigint(20) DEFAULT NULL COMMENT '画布ID',
  PRIMARY KEY (`id`),
  KEY `idx_projectId_logicId` (`project_id`,`main_logic_id`,`rel_logic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据模型-逻辑模型行为关联表';