create sequence lowcode_compiler_sequence
 increment by 1
 start with 1
 nomaxvalue
 nominvalue
 cache 20;

CREATE TABLE lowcode_compiler (
    id NUMBER(20) NOT NULL,
    project_id NUMBER(20) NOT NULL,
    module_id NUMBER(20) NOT NULL,
    bean_name VARCHAR2(64) NOT NULL,
    compiler_type NUMBER(4) DEFAULT '1' NOT NULL,
    compiler_code CLOB NOT NULL,
    compiler_data BLOB,
    compiler_state NUMBER(4) DEFAULT '0' NOT NULL,
    compiler_version NUMBER(11) DEFAULT '0' NOT NULL,
    ext1 VARCHAR2(255) DEFAULT NULL,
    ext2 VARCHAR2(255) DEFAULT NULL,
    ext3 VARCHAR2(255) DEFAULT NULL,
    valid NUMBER(4) DEFAULT NULL,
    create_user NUMBER(20) DEFAULT NULL,
    modified_user NUMBER(20) DEFAULT NULL,
    gmt_create DATE DEFAULT SYSDATE NOT NULL,
    gmt_modified DATE DEFAULT SYSDATE NOT NULL,
    constraint TF_LOWCODE_COMPILER_PK primary key(id),
    constraint LOWCODE_COMPILER_UNIQUE unique(bean_name)
);

create or replace trigger compiler_auto_add_trigger
	before insert on lowcode_compiler for each row
	begin
		select  lowcode_compiler_sequence.nextval into:new.id from dual
	end