/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.compiler;

import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class JavaSourceFileObject
extends SimpleJavaFileObject {
    private InputStream inputStream;

    protected JavaSourceFileObject(URI uri) {
        super(uri, JavaFileObject.Kind.SOURCE);
    }

    protected JavaSourceFileObject(String className, String code, Charset charset) {
        this(className, IoUtil.toStream(code, charset));
    }

    protected JavaSourceFileObject(String name, InputStream inputStream) {
        this(URLUtil.getStringURI(name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension));
        this.inputStream = inputStream;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.toUri().toURL().openStream();
        }
        return new BufferedInputStream(this.inputStream);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        try (InputStream in = this.openInputStream();){
            String string = IoUtil.readUtf8(in);
            return string;
        }
    }
}

