/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.domain;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.domain.ResultTrace;
import com.manatee.common.exception.BizException;
import java.lang.reflect.UndeclaredThrowableException;

public class ResultBase {
    protected boolean isSuccess = false;
    private ResultTrace resultTrace = new ResultTrace();
    private BizException exception;
    protected String msg;

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCodeId() {
        if (this.resultTrace == null) {
            return 1;
        }
        return this.resultTrace.getId();
    }

    public String getCode() {
        return this.resultTrace.getCode();
    }

    public String getSubCode() {
        return this.resultTrace.getSubCode();
    }

    public void setSubCode(String subCode) {
        this.resultTrace.setSubCode(subCode);
    }

    public void setResultTrace(ResultTrace resultTrace) {
        this.resultTrace = resultTrace;
        this.isSuccess = resultTrace.getId() >= 0;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultTrace.setResultCode(resultCode);
    }

    public void setResultCode(ResultCode resultCode, String subCode) {
        this.resultTrace.setSubCode(subCode);
        this.resultTrace.setResultCode(resultCode);
    }

    public void setResultCode(ResultCode resultCode, String subCode, String msg) {
        this.setResultCode(resultCode, subCode);
        this.resultTrace.setMsg(msg);
    }

    public void setResult(ResultBase resultBase) {
        this.resultTrace = resultBase.resultTrace;
        this.msg = resultBase.getMsg();
        this.isSuccess = resultBase.getCodeId() >= 0;
    }

    public void setBizException(BizException e) {
        this.exception = e;
        this.resultTrace = e.getResultTrace();
        if (this.resultTrace == null) {
            return;
        }
        this.resultTrace.setSubCode(e.getSubCode());
        this.isSuccess = this.resultTrace.getId() >= 0;
    }

    public void setException(Throwable e, String subCode) {
        this.setException(e);
        this.resultTrace.setSubCode(subCode);
    }

    public void setException(Throwable e) {
        BizException bizException = null;
        if (e instanceof BizException) {
            bizException = (BizException)e;
        } else if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclare = (UndeclaredThrowableException)e;
            bizException = (BizException)undeclare.getUndeclaredThrowable();
        } else {
            bizException = new BizException(ResultCode.SYSTEM_ERROR, e);
        }
        this.setBizException(bizException);
    }

    public ResultTrace getResultTrace() {
        return this.resultTrace;
    }

    public String getTraceId() {
        if (this.resultTrace == null) {
            return null;
        }
        return this.resultTrace.getTraceId();
    }

    public BizException getException() {
        return this.exception;
    }
}

