/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.history;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.process.service.ManateeTaskService;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryHistoricHighLightProcess
implements IProcess {
    @Resource
    private HistoryService historyService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ManateeTaskService manateeTaskService;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"processInstanceId"});
        HistoricActivityInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        historicProcessInstanceQuery.processInstanceId(processInstanceId).finished();
        historicTaskInstanceQuery.processInstanceId(processInstanceId).finished().orderByTaskDueDate().desc();
        List finishedList = historicProcessInstanceQuery.list();
        if (CollUtil.isEmpty((Collection)finishedList)) {
            return;
        }
        List list = historicTaskInstanceQuery.list();
        HashMap<String, String> keyReasonMap = new HashMap<String, String>();
        for (HistoricTaskInstance historicTaskInstance : list) {
            keyReasonMap.put(historicTaskInstance.getCaseDefinitionKey(), historicTaskInstance.getDeleteReason());
        }
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)finishedList.get(0);
        HashSet<String> highPoint = new HashSet<String>();
        HashSet<String> highLine = new HashSet<String>();
        HashSet<String> redPoint = new HashSet<String>();
        BpmnModelInstance bpmn = this.repositoryService.getBpmnModelInstance(historicActivityInstance.getProcessDefinitionId());
        int finishedNum = finishedList.size();
        for (int i = 0; i < finishedNum; ++i) {
            HistoricActivityInstance finItem = (HistoricActivityInstance)finishedList.get(i);
            String activityId = this.manateeTaskService.getActivityId(finItem);
            String reason = (String)keyReasonMap.get(finItem.getActivityId());
            if (StrUtil.startWith((CharSequence)reason, (CharSequence)"return@@:") || StrUtil.startWith((CharSequence)reason, (CharSequence)"refuse@@:")) {
                redPoint.add(activityId);
            } else {
                highPoint.add(activityId);
            }
            ModelElementInstance domElement = bpmn.getModelElementById(activityId);
            if (domElement == null) continue;
            FlowNode act = (FlowNode)domElement;
            Collection outgoing = act.getOutgoing();
            for (SequenceFlow sequenceFlow : outgoing) {
                String tarId = sequenceFlow.getTarget().getId();
                for (int j = 0; j < finishedNum; ++j) {
                    HistoricActivityInstance setpFinish = (HistoricActivityInstance)finishedList.get(j);
                    String finxId = this.manateeTaskService.getActivityId(setpFinish);
                    if (!tarId.equals(finxId) || !finItem.getEndTime().equals(setpFinish.getStartTime())) continue;
                    highLine.add(sequenceFlow.getId());
                }
            }
        }
        JSONObject result = new JSONObject();
        result.put("highPoint", highPoint);
        result.put("highLine", highLine);
        result.put("redPoint", redPoint);
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "camundaQueryHistoricHighLightProcess";
    }
}

