/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.oracle.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CloneUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OracleSqlProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DBManager dBManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"sql"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "oracle");
        DBQuery dbQueryForCount = (DBQuery)CloneUtil.cloneByStream((Object)dbQuery);
        this.jointLimit(dbQuery);
        if (dbQuery.getSql().toLowerCase().trim().startsWith("select")) {
            JSONObject totalCountJson;
            JSON data = this.dBManager.executeSelectSql(content, dbQuery);
            if (data != null) {
                this.outputUtil.handleAndPutData(content, (Object)data);
            }
            if ((totalCountJson = this.dBManager.querySqlTotalCount(dbQueryForCount, content)) != null) {
                this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
            }
        } else {
            int count = this.dBManager.executeNotSelectSql(content, dbQuery);
            this.outputUtil.setDefaultReturnKey(content, "count");
            this.outputUtil.putData(content, (Object)count);
        }
    }

    private void jointLimit(DBQuery dbQuery) {
        String originSql = dbQuery.getSql();
        if (dbQuery.getPage() != null) {
            StringBuilder sqlSB = new StringBuilder();
            sqlSB.append("SELECT * FROM (SELECT temp.*, ROWNUM LOWCODE_RN FROM (").append(originSql);
            Integer pageNum = dbQuery.getPage().getPageNum();
            Integer pageSize = dbQuery.getPage().getPageSize();
            if (pageNum != null && pageSize != null) {
                Integer skip = (pageNum - 1) * pageSize;
                sqlSB.append(") temp WHERE ROWNUM <= " + (skip + pageSize) + ") WHERE LOWCODE_RN >= " + (skip + 1) + " ");
            } else if (pageNum == null && pageSize != null) {
                Integer skip = pageSize;
                sqlSB.append(") temp WHERE ROWNUM <= " + (skip + pageSize) + ") ");
            } else {
                sqlSB = new StringBuilder(originSql);
            }
            dbQuery.setSql(sqlSB.toString());
        }
    }

    public String getName() {
        return "oracleSql";
    }
}

