/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import com.manatee.var.manager.VarManager;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class VariableUtil
implements IVariableUtil {
    @Resource
    private VarManager varManager;

    public String calRepVar(ProcessContent content, String exp) {
        if (StringUtil.isBlank(exp)) {
            return exp;
        }
        if (!VarManager.isHaveRepVar(exp)) {
            return exp;
        }
        exp = exp.replace("##VAR##", "${");
        exp = exp.replace("##VARS##", "}");
        return this.calVar(content, exp);
    }

    public String calVar(ProcessContent content, String exp) {
        if (StringUtil.isBlank(exp)) {
            return exp;
        }
        if (!VarManager.isHaveVar(exp)) {
            return exp;
        }
        Map<String, Object> param = this.getInputParam(content);
        if (param != null) {
            content.addTemp(param);
        }
        exp = this.varManager.varsReplace(content, exp);
        return exp;
    }

    public String calVarInConf(ProcessContent content, String confKey) {
        JSONObject conf = content.getStepConf();
        String key = conf.getString(confKey);
        if (StringUtil.isBlank(key)) {
            return null;
        }
        key = this.calVar(content, key);
        return key;
    }

    private Map<String, Object> getInputParam(ProcessContent content) {
        if (content == null) {
            return null;
        }
        JSONObject conf = content.getStepConf();
        String inputParam = conf.getString("inputParam");
        if (StringUtil.isBlank(inputParam)) {
            return null;
        }
        return (Map)content.getRequest(inputParam);
    }

    public String calVar(Map<String, Object> param, String exp) {
        if (param == null) {
            return exp;
        }
        if (StringUtil.isBlank(exp)) {
            return exp;
        }
        ProcessContent content = new ProcessContent();
        content.setTemp(param);
        exp = this.varManager.varsReplace(content, exp);
        return exp;
    }

    public static String cleanVar(String exp) {
        if (!VarManager.isHaveVar(exp)) {
            return exp;
        }
        return exp.replace("${", "").replace("}", "");
    }
}

