/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl;

import com.manatee.fun.IFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.TimeUtil;
import java.text.ParseException;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CalDateDiff
implements IFunction {
    private String name = "calDateDiff";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        String result = null;
        List parameters = content.getParameters();
        if (parameters == null || parameters.size() == 0) {
            return result;
        }
        if (parameters.size() < 3) {
            return result;
        }
        String dateStr1 = parameters.get(0).toString();
        String dateStr2 = parameters.get(1).toString();
        String type = parameters.get(2).toString();
        result = this.getDates(dateStr1, dateStr2, type);
        return result;
    }

    private String getDates(String dateStr1, String dateStr2, String type) {
        String result = null;
        String format = "yyyy-MM-dd";
        long d1 = this.getLongDate(dateStr1, format);
        long d2 = this.getLongDate(dateStr2, format);
        if ("day".equals(type)) {
            long days = (d1 - d2) / 86400000L;
            result = days + "";
        } else if ("month".equals(type)) {
            long months = (d1 - d2) / 2592000000L;
            result = months + "";
        } else if ("year".equals(type)) {
            long years = (d1 - d2) / 31104000000L;
            result = years + "";
        }
        return result;
    }

    private long getLongDate(String dateStr1, String farmat) {
        long d1 = 0L;
        if ("now".equals(dateStr1)) {
            d1 = System.currentTimeMillis();
        } else {
            try {
                d1 = TimeUtil.format2Date(dateStr1, farmat).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return d1;
    }
}

