/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dataModel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.lowcode.function.collection.GroupListMapFun;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ModelBehaviorRelProcess
implements IProcess {
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    private ProcessChain processChain;
    @Resource
    private GroupListMapFun groupListMapFun;

    public void process(ProcessContent content) throws BizException {
        JSONObject conf = content.getStepConf();
        Long projectId = content.getProjectId();
        String handleType = conf.getString("handleType");
        Long behaviorRelId = conf.getLong("behaviorRelId");
        JSONObject behaviorRelJson = this.processDataSource.getLogicBehaviorRel(projectId, behaviorRelId);
        JSONObject moduleJson = content.getModule();
        if (behaviorRelJson != null) {
            String paramsKey = conf.getString("paramsKey");
            Long relBehaviorId = behaviorRelJson.getLong("relBehaviorId");
            String relParamsStr = behaviorRelJson.getString("relParams");
            JSONArray relParamsArr = JSONArray.parseArray((String)relParamsStr);
            List attrList = this.processDataSource.getDataModelLogicAttr(projectId, behaviorRelJson.getLong("mainLogicId"));
            HashMap attrMap = new HashMap(attrList.size());
            for (Map m : attrList) {
                attrMap.put(m.get("id").toString(), m.get("attrCode"));
            }
            List behaviorParamsList = this.processDataSource.getBehaviorParams(projectId, relBehaviorId, null);
            HashMap inParamsMap = new HashMap(behaviorParamsList.size());
            String outParamsKey = "";
            for (Map m : behaviorParamsList) {
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)m.get("paramClass").toString(), (CharSequence)"1")) {
                    inParamsMap.put(m.get("id").toString(), m.get("paramCode"));
                    continue;
                }
                outParamsKey = m.get("paramCode").toString();
            }
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)handleType, (CharSequence)"batch") && behaviorRelJson.getIntValue("batchStatus") == 1) {
                Object params;
                Long relBatchBehaviorId = behaviorRelJson.getLong("relBatchBehaviorId");
                List<Step> steps = this.getStepList(content, projectId, relBatchBehaviorId);
                List list = (List)content.getRequest().get(paramsKey);
                ArrayList<Object> paramsList = new ArrayList<Object>();
                for (Object obj : list) {
                    Map paramsObj = (Map)obj;
                    params = new JSONObject();
                    for (Object relParamObj : relParamsArr) {
                        JSONObject relParamJson = (JSONObject)relParamObj;
                        Object paramKey = inParamsMap.get(relParamJson.getString("relParamId"));
                        Object valueKey = attrMap.get(relParamJson.getString("mainAttrId"));
                        if (paramKey == null) continue;
                        params.put(paramKey.toString(), paramsObj.get(valueKey));
                    }
                    paramsList.add(params);
                }
                List batchBehaviorParamsList = this.processDataSource.getBehaviorParams(projectId, relBatchBehaviorId, null);
                String batchInParamsKey = "";
                String batchOutParamsKey = "";
                for (Map m : batchBehaviorParamsList) {
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)m.get("paramClass").toString(), (CharSequence)"1")) {
                        batchInParamsKey = m.get("paramCode").toString();
                        continue;
                    }
                    batchOutParamsKey = m.get("paramCode").toString();
                }
                params = new JSONObject();
                params.put(batchInParamsKey, paramsList);
                ProcessContent moduleContent = new ProcessContent();
                moduleContent.setRequest((Map)params);
                moduleContent.setTransactionCon(content.getTransactionCon());
                moduleContent.setModule(content.getModule());
                params.put("tempContext", content.getRequest("tempContext"));
                params.put("cells", content.getRequest("cells"));
                this.processChain.executeSteps(moduleContent, steps);
                Map moduleResponse = moduleContent.getResponse();
                List resultList = (List)moduleResponse.get(batchOutParamsKey);
                ArrayList<String> groupKeyList = new ArrayList<String>();
                FunctionContent functionContent = new FunctionContent();
                functionContent.setParameter((Object)resultList);
                for (Object relParamObj : relParamsArr) {
                    JSONObject relParamJson = (JSONObject)relParamObj;
                    Object paramKey = inParamsMap.get(relParamJson.getString("relParamId"));
                    Object valueKey = attrMap.get(relParamJson.getString("mainAttrId"));
                    if (paramKey == null) continue;
                    groupKeyList.add(valueKey.toString());
                    functionContent.setParameter((Object)paramKey.toString());
                }
                Map groupResultMap = (Map)this.groupListMapFun.doFunction(functionContent);
                for (Object obj : list) {
                    Map paramsObj = (Map)obj;
                    ArrayList<String> groupKey = new ArrayList<String>();
                    for (String keyTemp : groupKeyList) {
                        groupKey.add((String)(paramsObj.get(keyTemp) != null ? paramsObj.get(keyTemp) : ""));
                    }
                    String groupKeyStr = StringUtils.join(groupKey, (String)"_");
                    paramsObj.put(attrMap.get(behaviorRelJson.getString("mainLogicAttrId")).toString(), groupResultMap.get(groupKeyStr));
                }
            } else {
                List<Step> steps = this.getStepList(content, projectId, relBehaviorId);
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)handleType, (CharSequence)"batch")) {
                    List list = (List)content.getRequest().get(paramsKey);
                    for (Object obj : list) {
                        Map paramsObj = (Map)obj;
                        Map<String, Object> moduleResponse = this.executeSteps(content, steps, paramsObj, relParamsArr, attrMap, inParamsMap);
                        paramsObj.put(attrMap.get(behaviorRelJson.getString("mainLogicAttrId")).toString(), moduleResponse.get(outParamsKey));
                    }
                } else {
                    Map paramsObj = (Map)content.getRequest().get(paramsKey);
                    Map<String, Object> moduleResponse = this.executeSteps(content, steps, paramsObj, relParamsArr, attrMap, inParamsMap);
                    paramsObj.put(attrMap.get(behaviorRelJson.getString("mainLogicAttrId")).toString(), moduleResponse.get(outParamsKey));
                }
            }
        }
        content.setModule(moduleJson);
    }

    private Map<String, Object> executeSteps(ProcessContent content, List<Step> steps, Map paramsObj, JSONArray relParamsArr, Map attrMap, Map inParamsMap) throws BizException {
        JSONObject params = new JSONObject();
        for (Object relParamObj : relParamsArr) {
            JSONObject relParamJson = (JSONObject)relParamObj;
            Object paramKey = inParamsMap.get(relParamJson.getString("relParamId"));
            Object valueKey = attrMap.get(relParamJson.getString("mainAttrId"));
            if (paramKey == null) continue;
            params.put(paramKey.toString(), paramsObj.get(valueKey));
        }
        ProcessContent moduleContent = new ProcessContent();
        moduleContent.setRequest((Map)params);
        moduleContent.setTransactionCon(content.getTransactionCon());
        moduleContent.setModule(content.getModule());
        params.put("tempContext", content.getRequest("tempContext"));
        params.put("cells", content.getRequest("cells"));
        this.processChain.executeSteps(moduleContent, steps);
        Map moduleResponse = moduleContent.getResponse();
        return moduleResponse;
    }

    private List<Step> getStepList(ProcessContent content, Long projectId, Long relBehaviorId) throws BizException {
        JSONObject behaviorJson = this.processDataSource.getLogicBehaviorById(projectId, relBehaviorId);
        if (behaviorJson == null) {
            BizException exception = new BizException(ResultCode.SYSTEM_ERROR);
            exception.setMsg("\u5173\u8054\u884c\u4e3a\u4e0d\u5b58\u5728");
            throw exception;
        }
        Long moduleId = behaviorJson.getLong("moduleId");
        ModuleBO moduleBO = this.processDataSource.getModule(projectId, moduleId);
        if (moduleBO == null || moduleBO.getSteps() == null) {
            BizException exception = new BizException(ResultCode.SYSTEM_ERROR, "module_is_null");
            if (moduleBO != null) {
                exception.putDefaultParam(moduleBO.getCode());
            } else {
                exception.putDefaultParam("ID:" + moduleId);
            }
            throw exception;
        }
        List steps = moduleBO.getSteps();
        JSONObject tempModuleJson = new JSONObject();
        tempModuleJson.put("systemVersion", (Object)moduleBO.getSystemVersion());
        tempModuleJson.put("name", (Object)moduleBO.getName());
        tempModuleJson.put("url", (Object)moduleBO.getPath());
        tempModuleJson.put("lowcodeModule", (Object)moduleBO.getCode());
        content.setModule(tempModuleJson);
        return steps;
    }

    public String getName() {
        return "modelBehaviorRelProcess";
    }
}

