/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.EnumUtil;
import com.manatee.common.util.tool.core.util.ReflectUtil;
import com.manatee.lowcode.util.CacheRamUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class ManateeJavaSpringBeanUtil
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext context;
    @Resource
    private CacheRamUtil cacheRamUtil;
    private static final HashMap<String, Class> calssMap = new HashMap(){
        {
            this.put("double", Double.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("char", Character.TYPE);
            this.put("float", Float.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("short", Short.TYPE);
        }
    };
    private static final Set<String> filterMethodSet = new HashSet<String>(){
        {
            this.add("protected void java.lang.Object.finalize() throws java.lang.Throwable");
            this.add("public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException");
            this.add("public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException");
            this.add("public final void java.lang.Object.wait() throws java.lang.InterruptedException");
            this.add("public boolean java.lang.Object.equals(java.lang.Object)");
            this.add("public java.lang.String java.lang.Object.toString()");
            this.add("public native int java.lang.Object.hashCode()");
            this.add("public final native java.lang.Class java.lang.Object.getClass()");
            this.add("protected native java.lang.Object java.lang.Object.clone() throws java.lang.CloneNotSupportedException");
            this.add("private static native void java.lang.Object.registerNatives()");
            this.add("public final native void java.lang.Object.notify()");
            this.add("public final native void java.lang.Object.notifyAll()");
            this.add("private void java.lang.Enum.readObjectNoData() throws java.io.ObjectStreamException");
            this.add("public final java.lang.String java.lang.Enum.name()");
            this.add("protected final void java.lang.Enum.finalize()");
            this.add("public final boolean java.lang.Enum.equals(java.lang.Object)");
            this.add("public java.lang.String java.lang.Enum.toString()");
            this.add("public final int java.lang.Enum.hashCode()");
            this.add("protected final java.lang.Object java.lang.Enum.clone() throws java.lang.CloneNotSupportedException");
            this.add("public int java.lang.Enum.compareTo(java.lang.Object)");
            this.add("public final int java.lang.Enum.compareTo(java.lang.Enum)");
            this.add("public static java.lang.Enum java.lang.Enum.valueOf(java.lang.Class,java.lang.String)");
            this.add("public final java.lang.Class java.lang.Enum.getDeclaringClass()");
            this.add("private void java.lang.Enum.readObject(java.io.ObjectInputStream) throws java.io.IOException,java.lang.ClassNotFoundException");
            this.add("public final int java.lang.Enum.ordinal()");
            this.add("protected void java.lang.Object.finalize() throws java.lang.Throwable");
            this.add("public final void java.lang.Object.wait() throws java.lang.InterruptedException");
            this.add("public final void java.lang.Object.wait(long,int) throws java.lang.InterruptedException");
            this.add("public final native void java.lang.Object.wait(long) throws java.lang.InterruptedException");
            this.add("public boolean java.lang.Object.equals(java.lang.Object)");
            this.add("public java.lang.String java.lang.Object.toString()");
            this.add("public native int java.lang.Object.hashCode()");
            this.add("public final native java.lang.Class java.lang.Object.getClass()");
            this.add("protected native java.lang.Object java.lang.Object.clone() throws java.lang.CloneNotSupportedException");
            this.add("public final native void java.lang.Object.notify()");
            this.add("public final native void java.lang.Object.notifyAll()");
            this.add("private static native void java.lang.Object.registerNatives()");
        }
    };

    public void afterPropertiesSet() throws Exception {
    }

    public Object getBean(String name) {
        return this.context.getBean(name);
    }

    public <T> T getBean(Class<T> requiredType) {
        return (T)this.context.getBean(requiredType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public Object invokeMethod(String serviceName, String methodName, Object[] params) throws BizException {
        Object service = null;
        try {
            service = this.getBean(serviceName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Class<?> serviceClass = null;
        if (service != null) {
            serviceClass = service.getClass();
        } else {
            try {
                serviceClass = Class.forName(serviceName);
                service = serviceClass.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Class<?>[] paramClass = this.getParams(params);
        Method method = this.getMethod(serviceName, methodName, serviceClass, paramClass);
        return ReflectionUtils.invokeMethod((Method)method, (Object)service, (Object[])params);
    }

    public Object invokeMethod(String serviceName, String methodName, Object[] params, JSONObject param) throws BizException {
        Object service = null;
        try {
            service = this.getBean(serviceName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Class<?> serviceClass = null;
        if (service != null) {
            serviceClass = service.getClass();
        } else {
            try {
                serviceClass = Class.forName(serviceName);
                service = serviceClass.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (Map.Entry entry : param.entrySet()) {
            Object param1 = params[i];
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("class", (Object)entry.getValue().toString());
            jsonObject.put("value", param1);
            jsonArray.add((Object)jsonObject);
            ++i;
        }
        Class<?>[] paramClass = this.getParams(jsonArray);
        Method method = this.getMethod(serviceName, methodName, serviceClass, paramClass);
        return ReflectionUtils.invokeMethod((Method)method, (Object)service, (Object[])params);
    }

    private Method getMethod(String serviceName, String methodName, Class<?> serviceClass, Class<?>[] paramClass) throws BizException {
        Method method = this.getMethod(serviceClass, methodName, paramClass);
        if (method == null) {
            BizException e = new BizException(ResultCode.BIZ_ERROR, "method_not_find");
            e.putDefaultParam(serviceName + "." + methodName);
            throw e;
        }
        return method;
    }

    public Object invokeMethod(String serviceName, String atributeName, String methodName, Object[] params) throws BizException {
        Object service = null;
        Class<?> serviceClass = null;
        try {
            serviceClass = Class.forName(serviceName);
            if (EnumUtil.isEnum(serviceClass)) {
                LinkedHashMap enumMap = EnumUtil.getEnumMap(serviceClass);
                service = enumMap.get(atributeName);
            }
        }
        catch (Throwable enumMap) {
            // empty catch block
        }
        Class<?>[] paramClass = this.getParams(params);
        Class<?> aClass = service.getClass();
        Method method = null;
        try {
            method = aClass.getMethod(methodName, paramClass);
        }
        catch (NoSuchMethodException e) {
            BizException biz = new BizException(ResultCode.BIZ_ERROR, "class_not_find");
            biz.putDefaultParam(serviceName + "." + methodName);
            throw biz;
        }
        if (method == null) {
            BizException e = new BizException(ResultCode.BIZ_ERROR, "method_not_find");
            e.putDefaultParam(serviceName + "." + methodName);
            throw e;
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)service, (Object[])params);
    }

    private Method getMethod(Class<?> serviceClass, String methodName, Class<?>[] paramClass) {
        Method method;
        String methodCacheKey = this.getMethodCacheKey(serviceClass, methodName, paramClass);
        Object methodObj = this.cacheRamUtil.getCache(methodCacheKey);
        if (methodObj != null) {
            method = (Method)methodObj;
        } else {
            method = ReflectionUtils.findMethod(serviceClass, (String)methodName, (Class[])(paramClass = this.paramClassCheck(methodName, paramClass, serviceClass)));
            if (method != null) {
                this.cacheRamUtil.setCache(methodCacheKey, (Object)method, Integer.valueOf(1));
            }
        }
        return method;
    }

    private String getMethodCacheKey(Class<?> serviceClass, String methodName, Class<?>[] paramClass) {
        StringBuilder keySb = new StringBuilder(serviceClass.getName());
        keySb.append("_").append(serviceClass.getName()).append("_").append(methodName);
        for (Class<?> obj : paramClass) {
            keySb.append("_").append(obj.getName());
        }
        return keySb.toString();
    }

    private Class<?>[] paramClassCheck(String methodName, Class<?>[] paramClass, Class<?> serviceClass) {
        for (Method method : serviceClass.getMethods()) {
            Class<?>[] originalParamClass;
            if (!method.getName().equals(methodName) || (originalParamClass = method.getParameterTypes()).length != paramClass.length) continue;
            boolean isAssignable = true;
            for (int i = 0; i < originalParamClass.length && (isAssignable = originalParamClass[i].isAssignableFrom(paramClass[i])); ++i) {
            }
            if (!isAssignable) continue;
            paramClass = originalParamClass;
            break;
        }
        return paramClass;
    }

    private Class<?>[] getParams(Object[] params) {
        Class[] paramClass = null;
        if (params != null) {
            int paramsLength = params.length;
            paramClass = new Class[paramsLength];
            for (int i = 0; i < paramsLength; ++i) {
                if (params[i] instanceof List) {
                    paramClass[i] = List.class;
                    continue;
                }
                if (params[i] instanceof Map) {
                    if (params[i] instanceof JSONObject) {
                        paramClass[i] = JSONObject.class;
                        continue;
                    }
                    paramClass[i] = Map.class;
                    continue;
                }
                paramClass[i] = params[i].getClass();
            }
        }
        return paramClass;
    }

    private Class<?>[] getParams(JSONArray jsonArray) {
        Class[] paramClass = null;
        if (jsonArray != null) {
            int paramsLength = jsonArray.size();
            paramClass = new Class[paramsLength];
            int i = 0;
            for (Object obj : jsonArray) {
                String key;
                JSONObject entry = (JSONObject)obj;
                Object value = entry.get((Object)"value");
                paramClass[i] = value instanceof List ? List.class : (value instanceof Map ? (value instanceof JSONObject ? JSONObject.class : Map.class) : (calssMap.get(key = (String)entry.get((Object)"class")) == null ? value.getClass() : calssMap.get(key)));
                ++i;
            }
        }
        return paramClass;
    }

    public List<JSONObject> getMethodAndParamByClassOrBeanName(String classOrBeanName) {
        Class<?> aClass;
        ArrayList<JSONObject> methodParamList = new ArrayList<JSONObject>();
        if (classOrBeanName.indexOf(".") > -1) {
            try {
                aClass = Class.forName(classOrBeanName);
            }
            catch (ClassNotFoundException e) {
                return new ArrayList<JSONObject>();
            }
        } else {
            Object object = this.getBean(classOrBeanName);
            if (object == null) {
                return new ArrayList<JSONObject>();
            }
            aClass = object.getClass();
        }
        Method[] methods = ReflectUtil.getMethods(aClass);
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        for (Method method : methods) {
            JSONObject methodParamJson = new JSONObject();
            if (filterMethodSet.contains(method.toString()) || method.toString().indexOf("org.slf4j.Logger") != -1) continue;
            JSONObject paramJson = new JSONObject(true);
            JSONObject paramTypeJson = new JSONObject(true);
            Object[] parameterNames = discover.getParameterNames(method);
            if (parameterNames != null) {
                for (int i = 0; i < method.getParameters().length; ++i) {
                    String paramName;
                    Parameter[] parameters = method.getParameters();
                    String paramValue = paramName = parameterNames[i];
                    String paramtypeName = parameters[i].getType().getName();
                    if (paramtypeName.indexOf(".") != -1 && !paramtypeName.startsWith("java.")) {
                        try {
                            Class<?> customClass = Class.forName(paramtypeName);
                            Field[] fields = customClass.getDeclaredFields();
                            JSONObject paramValueJson = new JSONObject();
                            for (Field field : fields) {
                                paramValueJson.put(field.getName(), (Object)field.getName());
                            }
                            paramValue = paramValueJson;
                        }
                        catch (ClassNotFoundException e) {
                            paramValue = new JSONObject();
                        }
                    }
                    paramJson.put(paramName, (Object)paramValue);
                    paramTypeJson.put(paramName, (Object)paramtypeName);
                }
            }
            methodParamJson.put("name", (Object)(method.getName() + "(" + StringUtils.join((Object[])parameterNames, (String)",") + ")"));
            methodParamJson.put("value", (Object)method.getName());
            methodParamJson.put("params", (Object)this.jointSb(paramJson));
            methodParamJson.put("paramsType", (Object)this.jointSb(paramTypeJson));
            methodParamJson.put("key", (Object)(method.getName() + paramTypeJson.toString().hashCode()));
            methodParamList.add(methodParamJson);
        }
        return methodParamList;
    }

    private String jointSb(JSONObject json) {
        StringBuilder sb = new StringBuilder();
        for (String key : json.keySet()) {
            Object value = json.get((Object)key);
            if (value instanceof JSONObject) {
                JSONObject objJson = (JSONObject)value;
                sb = sb.append(key).append(" = ").append("{\n");
                for (String objKey : objJson.keySet()) {
                    Object objValue = objJson.get((Object)objKey);
                    sb = sb.append("\t").append(objKey).append(" = ").append(objValue).append(",\n");
                }
                if (objJson.size() > 0) {
                    sb = new StringBuilder(sb.substring(0, sb.length() - 2));
                    sb.append("\n");
                }
                sb = sb.append("};\n");
                continue;
            }
            sb = sb.append(key).append(" = ").append(value).append(";\n");
        }
        if (json.size() > 0) {
            sb = new StringBuilder(sb.substring(0, sb.length() - 2));
            sb.append("\n");
        }
        return sb.toString();
    }
}

