/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.MDC;

public class ManateeLogAppender<E>
extends ConsoleAppender<E> {
    private static final Map<String, StringBuilder> requestLogs = new ConcurrentHashMap<String, StringBuilder>();

    protected void subAppend(E event) {
        if (this.isStarted()) {
            try {
                if (event instanceof DeferredProcessingAware) {
                    ((DeferredProcessingAware)event).prepareForDeferredProcessing();
                }
                byte[] byteArray = this.encoder.encode(event);
                this.writeBytes(byteArray);
            }
            catch (IOException var3) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)var3));
            }
        }
    }

    private void writeBytes(byte[] byteArray) throws IOException {
        if (byteArray != null && byteArray.length != 0) {
            String requestId = MDC.get((String)"traceId");
            if (StrUtil.isBlank((CharSequence)requestId)) {
                return;
            }
            StringBuilder logBuilder = requestLogs.get(requestId);
            if (logBuilder == null) {
                logBuilder = new StringBuilder();
                requestLogs.put(requestId, logBuilder);
            }
            if (logBuilder.length() <= 1000) {
                logBuilder.append(new String(byteArray)).append(System.lineSeparator());
            }
        }
    }

    public static String getRequestLogs() {
        String requestId = MDC.get((String)"traceId");
        StringBuilder logBuilder = requestLogs.remove(requestId);
        if (logBuilder == null) {
            return null;
        }
        return logBuilder.toString();
    }
}

