/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.log.Formatter;
import com.manatee.lowcode.log.ManateeLoggerContext;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogbackLoggerContext
implements ManateeLoggerContext {
    @Override
    public void generateAppender() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("ROOT");
        ManateeLogbackAppender appender = new ManateeLogbackAppender();
        appender.setContext((Context)context);
        appender.setName("ManateeLog");
        appender.start();
        logger.addAppender((Appender)appender);
    }

    static class ManateeLogbackAppender
    extends UnsynchronizedAppenderBase<ILoggingEvent> {
        ManateeLogbackAppender() {
        }

        protected void append(ILoggingEvent event) {
            String requestId = MDC.get((String)"traceId");
            if (StrUtil.isBlank((CharSequence)requestId) || !requestId.startsWith("D-")) {
                return;
            }
            String loggerName = event.getLoggerName();
            Formatter formatter = Formatter.create().timestamp(event.getTimeStamp()).value(" --- [").traceId(requestId).value("] ").level(event.getLevel().toString()).value(" --- [").thread(event.getThreadName()).value("] ").loggerName(loggerName).value(": ").value(event.getFormattedMessage()).newline();
            IThrowableProxy proxy = event.getThrowableProxy();
            if (proxy instanceof ThrowableProxy) {
                formatter.throwable(((ThrowableProxy)proxy).getThrowable());
            }
            boolean isJsProcess = false;
            if (loggerName.endsWith("JsProcess")) {
                isJsProcess = true;
            }
            ManateeLoggerContext.println(formatter.toString(), isJsProcess);
        }
    }
}

