/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.other;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.common.util.tool.core.util.IdUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class RandomIdFun
extends AbstractFunction {
    private String name = "randomId";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        this.checkParamExist(content);
        List parameters = content.getParameters();
        String idType = (String)parameters.get(0);
        if (StringUtil.isBlank((String)idType)) {
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0cidType\u4e3a\u7a7a", this.getName()), (String)this.getName());
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        idType = idType.trim().toLowerCase();
        return this.getRandomIdByIdType(idType, parameters, content);
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 3;
    }

    private String getRandomIdByIdType(String idType, List<Object> parameters, FunctionContent functionContent) {
        String randomId;
        switch (idType) {
            case "uuid": {
                randomId = IdUtil.randomUUID();
                break;
            }
            case "simpleuuid": {
                randomId = IdUtil.simpleUUID();
                break;
            }
            case "objectid": {
                randomId = IdUtil.objectId();
                break;
            }
            case "snowflake": {
                Integer datacenterId;
                Integer workerId;
                if (parameters.size() > 2) {
                    workerId = (Integer)parameters.get(1);
                    datacenterId = (Integer)parameters.get(2);
                } else {
                    workerId = 1;
                    datacenterId = 1;
                }
                randomId = IdUtil.getSnowflake((long)workerId.intValue(), (long)datacenterId.intValue()).nextIdStr();
                break;
            }
            default: {
                randomId = IdUtil.randomUUID();
                FunctionContentUtil.addUnBlockError((FunctionContent)functionContent, (String)String.format("\u51fd\u6570\uff1a%s\uff0cidType\u6ca1\u6709\u5339\u914d\u5230", this.getName()), (String)this.getName());
            }
        }
        return randomId;
    }

    public static String next(boolean withHyphen) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[12]);
        bb.putInt((int)DateUtil.currentSeconds());
        bb.putInt(10);
        bb.putInt(1000);
        byte[] array = bb.array();
        StringBuilder buf = new StringBuilder(withHyphen ? 26 : 24);
        for (int i = 0; i < array.length; ++i) {
            int t;
            if (withHyphen && i % 4 == 0 && i != 0) {
                buf.append("-");
            }
            if ((t = array[i] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(t));
        }
        return buf.toString();
    }
}

