/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.manatee.common.util.SerializeUtil;
import com.manatee.common.util.StrUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.redis.domain.ScanQuery;
import com.manatee.redis.util.RedisClusterClientInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;

@Service
public class RedisClusterReadUtil {
    private final Logger log = LoggerFactory.getLogger(RedisClusterReadUtil.class);
    @Resource
    private RedisClusterClientInit redisClusterClientInit;

    public Long getTtl(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Long value = null;
        if (jedis != null) {
            try {
                value = jedis.ttl(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public String getValue(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        String value = null;
        if (jedis != null) {
            try {
                value = jedis.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public String getValue(String key) {
        return this.getValue(0, key);
    }

    public List<String> getValues(int db, String[] keys) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        List values = null;
        if (jedis != null) {
            try {
                values = jedis.mget(keys);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return values;
    }

    private List<String> hmgetValue(JedisCluster jedis, int db, String objectName, String ... fields) {
        List values = null;
        if (jedis != null) {
            values = jedis.hmget(objectName, fields);
        }
        return values;
    }

    public Map<String, Object> hmgetValue(int db, String objectName, String ... fields) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Map<String, Object> valueMap = null;
        if (jedis != null) {
            try {
                List<String> values = this.hmgetValue(jedis, db, objectName, fields);
                valueMap = this.list2LinkedMap(fields, values);
            }
            catch (Exception e) {
                this.log.error("[hgetValue]_exception", (Throwable)e);
                throw e;
            }
        }
        return valueMap;
    }

    public String hmgetStrValue(int db, String objectName, String field) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        try {
            String[] fields = new String[]{field};
            List<String> values = this.hmgetValue(jedis, db, objectName, fields);
            if (values.size() > 0) {
                return values.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Map<String, String> hmgetAll(JedisCluster jedis, int db, String objectName) {
        Map valueMap = null;
        if (jedis != null) {
            valueMap = jedis.hgetAll(objectName);
        }
        return valueMap;
    }

    public Map<String, String> hmgetAll(int db, String objectName) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Map<String, String> valueMap = null;
        if (jedis != null) {
            try {
                valueMap = this.hmgetAll(jedis, db, objectName);
            }
            catch (Exception e) {
                this.log.error("[hmgetAll]_exception", (Throwable)e);
                throw e;
            }
        }
        return valueMap;
    }

    public List<Map<String, String>> hmgetBatchAll(int db, List<String> keys) throws Exception {
        if (keys == null || keys.size() == 0) {
            this.log.error("[hmgetBatchAll]_exception", (Object)"hkeys is null");
            throw new Exception("[hmgetBatchValue]_exception hkeys is null");
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        if (jedis != null) {
            try {
                for (String objectKey : keys) {
                    Map<String, String> valueMap = this.hmgetAll(jedis, db, objectKey);
                    if (valueMap == null || valueMap.isEmpty()) continue;
                    result.add(valueMap);
                }
            }
            catch (Exception e) {
                this.log.error("[hmgetBatchValue]_exception", (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    public Map<String, Object> hmgetBatchAllToMap(int db, List<String> keys) throws Exception {
        if (keys == null || keys.size() == 0) {
            this.log.error("[hmgetBatchAll]_exception", (Object)"hkeys is null");
            throw new Exception("[hmgetBatchValue]_exception hkeys is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        if (jedis != null) {
            try {
                for (String key : keys) {
                    Map<String, String> valueMap = this.hmgetAll(jedis, db, key);
                    if (valueMap == null || valueMap.isEmpty()) continue;
                    result.put(key, valueMap);
                }
            }
            catch (Exception e) {
                this.log.error("[hmgetBatchValue]_exception", (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    public List<Map<String, Object>> hmgetBatchValue(int db, List<String> keys, String[] fields) throws Exception {
        if (keys == null || keys.size() == 0) {
            this.log.error("[hmgetBatchValue]_exception", (Object)"hkeys is null");
            throw new Exception("[hmgetBatchValue]_exception hkeys is null");
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        if (jedis != null) {
            try {
                for (String key : keys) {
                    List<String> values = this.hmgetValue(jedis, db, key, fields);
                    Map<String, Object> valueMap = this.list2LinkedMap(fields, values);
                    if (valueMap == null || valueMap.isEmpty()) continue;
                    result.add(valueMap);
                }
            }
            catch (Exception e) {
                this.log.error("[hmgetBatchValue]_exception", (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    private Map<String, Object> list2LinkedMap(String[] fields, List<String> values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            String value = values.get(i);
            if (value == null) continue;
            result.put(fieldName, value);
        }
        return result;
    }

    public Object getValue(byte[] key) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Object result = null;
        if (jedis != null) {
            try {
                byte[] in = jedis.get(key);
                result = SerializeUtil.deserialize((byte[])in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<String> getList(String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        List list = null;
        if (jedis != null) {
            try {
                list = jedis.lrange(key, start, end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> getList(int db, String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        List list = null;
        if (jedis != null) {
            try {
                list = jedis.lrange(key, start, end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> scan(String pattern) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        List<String> list = new ArrayList<String>();
        if (jedis != null) {
            try {
                int count = 1000;
                list = this.scan(jedis, pattern, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> scan(String pattern, int count) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        List<String> list = new ArrayList<String>();
        if (jedis != null) {
            try {
                list = this.scan(jedis, pattern, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> scan(String pattern, int count, int db) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        List<String> list = new ArrayList<String>();
        if (jedis != null) {
            try {
                list = this.scan(jedis, pattern, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> scanLimit(String pattern, int limit, int db) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        ArrayList<String> list = new ArrayList<String>();
        if (jedis != null) {
            try {
                this.scan(pattern, limit, jedis, list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> scanLimit(ScanQuery scanQuery) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        ArrayList<String> list = new ArrayList<String>();
        if (jedis != null) {
            try {
                this.scan(scanQuery, jedis, list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> scanLimitForSear(String pattern, int limit, int db) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        ArrayList<String> list = new ArrayList<String>();
        if (jedis != null) {
            try {
                String[] PRI = new String[]{"1:", "*0:"};
                String[] PRI2 = new String[]{"*0:"};
                String[] PRI3 = new String[]{"1:"};
                String keyword = pattern.replace("*", "").replace("_", "");
                if (StrUtils.isChinese((String)keyword)) {
                    this.scanForSer(pattern, limit, jedis, list, PRI2);
                } else if (keyword.length() <= 2 && (StringUtil.isEnglish((String)keyword) || StringUtil.isInteger((String)keyword).booleanValue())) {
                    limit = 1000;
                    this.scanForSer(pattern, limit, jedis, list, PRI3);
                } else {
                    this.scanForSer(pattern, limit, jedis, list, PRI);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private void scanForSer(String pattern, int limit, JedisCluster jedis, List<String> list, String[] PRI) {
        for (String i : PRI) {
            String pt = i + pattern;
            this.scan(pt, limit, jedis, list);
            if (list.size() >= limit) break;
        }
    }

    private void scan(String pattern, int limit, Integer cursor, JedisCluster jedis, List<String> list) {
        ScanParams params = new ScanParams();
        params.count(Integer.valueOf(1000));
        params.match(pattern);
        String cursorStr = cursor + "";
        do {
            ScanResult result = jedis.scan(cursorStr, params);
            cursorStr = result.getStringCursor();
            list.addAll(result.getResult());
        } while (!"0".equals(cursorStr) && list.size() < limit);
    }

    private void scan(ScanQuery scanQuery, JedisCluster jedis, List<String> list) {
        ScanParams params = new ScanParams();
        params.count(Integer.valueOf(1000));
        params.match(scanQuery.getScanKey());
        String cursorStr = scanQuery.getCursor() + "";
        do {
            ScanResult result = jedis.scan(cursorStr, params);
            cursorStr = result.getStringCursor();
            list.addAll(result.getResult());
        } while (!"0".equals(cursorStr) && list.size() < scanQuery.getLimit());
        Integer cursor = Integer.valueOf(cursorStr);
        scanQuery.setCursor(cursor);
    }

    private void scan(String pattern, int limit, JedisCluster jedis, List<String> list) {
        this.scan(pattern, limit, 0, jedis, list);
    }

    public List<String> scan(JedisCluster jedis, String pattern, int count) {
        ArrayList<String> keys = new ArrayList<String>();
        ScanParams params = new ScanParams();
        params.count(Integer.valueOf(count));
        params.match(pattern);
        String cursor = "0";
        do {
            ScanResult result = jedis.scan(cursor, params);
            cursor = result.getStringCursor();
            keys.addAll(result.getResult());
        } while (!"0".equals(cursor));
        return keys;
    }

    public Map<String, String> hscan(String key, String pattern, int count, int db) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Map<String, String> resultMap = new HashMap<String, String>();
        if (jedis != null) {
            try {
                resultMap = this.hscan(jedis, key, pattern, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultMap;
    }

    public List<Map<String, String>> hscanBatch(List<String> keys, String pattern, int count, int db) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        if (jedis != null) {
            try {
                for (String key : keys) {
                    Map<String, String> map = this.hscan(jedis, key, pattern, count);
                    listMap.add(map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listMap;
    }

    private Map<String, String> hscan(JedisCluster jedis, String key, String pattern, int count) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        List entryList = null;
        ScanParams params = new ScanParams();
        params.count(Integer.valueOf(count));
        params.match(pattern);
        String cursor = "0";
        do {
            ScanResult result = jedis.hscan(key, cursor, params);
            cursor = result.getStringCursor();
            if (entryList == null) {
                entryList = result.getResult();
                continue;
            }
            entryList.addAll(result.getResult());
        } while (!"0".equals(cursor));
        RedisClusterReadUtil.putResult(key, resultMap, entryList);
        return resultMap;
    }

    private static void putResult(String key, Map<String, String> resultMap, List<Map.Entry<String, String>> entryList) {
        for (Map.Entry<String, String> entry : entryList) {
            String entryKey = entry.getKey();
            String entryValue = entry.getValue();
            resultMap.put(entryKey, entryValue);
        }
        resultMap.put("keyCount", entryList.size() + "");
        if (key.contains(":")) {
            String primaryKey = key.substring(key.lastIndexOf(":"));
            resultMap.put("primaryKey", primaryKey);
        }
    }

    public Set<String> smembers(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Set result = null;
        if (null != jedis) {
            try {
                result = jedis.smembers(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean sismember(int db, String key, String member) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        boolean result = false;
        if (null != jedis) {
            try {
                result = jedis.sismember(key, member);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Set<String> zrevrange(int db, String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Set result = null;
        if (jedis != null) {
            try {
                result = jedis.zrevrange(key, start, end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Set<String> zrange(int db, String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Set result = null;
        if (jedis != null) {
            try {
                result = jedis.zrange(key, start, end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public long zremrangeByRank(int db, String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.zremrangeByRank(key, start, end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public long zcount(int db, String key, double min, double max) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.zcount(key, min, max);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public double zscore(int db, String key, String member) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        Double score = 0.0;
        if (jedis != null) {
            try {
                score = jedis.zscore(key, member);
                if (score == null) {
                    score = 0.0;
                }
            }
            catch (Exception e) {
                this.log.error("[RedisClient.zscore]_biz_error,key:{},member:{}", (Object)key, (Object)member);
                e.printStackTrace();
            }
        }
        return score;
    }

    public Map<String, Double> zrevrangeWithScores(int db, String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        LinkedHashMap<String, Double> result = new LinkedHashMap<String, Double>();
        if (jedis != null) {
            try {
                Set tuples = jedis.zrevrangeWithScores(key, start, end);
                for (Tuple tuple : tuples) {
                    result.put(tuple.getElement(), tuple.getScore());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Map<String, Double> zrangeWithScores(int db, String key, long start, long end) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        LinkedHashMap<String, Double> result = new LinkedHashMap<String, Double>();
        if (jedis != null) {
            try {
                Set tuples = jedis.zrangeWithScores(key, start, end);
                for (Tuple tuple : tuples) {
                    result.put(tuple.getElement(), tuple.getScore());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public long ttl(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        long result = 0L;
        if (jedis != null) {
            try {
                result = jedis.ttl(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean exists(int db, String key) {
        JedisCluster jedis = this.redisClusterClientInit.getReadPoolInstance();
        boolean result = false;
        if (jedis != null) {
            try {
                result = jedis.exists(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

