/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.config;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.manager.SpringContextManager;
import com.manatee.redis.config.RedisClusterProperties;
import java.io.IOException;
import java.net.URL;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.stereotype.Component;

@Component
public class ManateeRedissonConfig
implements ApplicationListener<ContextStartedEvent> {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeRedissonConfig.class);
    @Value(value="${spring.redis.host:}")
    private String hostInSpringRedis;
    @Value(value="${spring.redis.port:}")
    private String portInSpringRedis;
    @Value(value="${spring.redis.password:}")
    private String passwordInSpringRedis;
    @Autowired
    private RedisClusterProperties redisClusterProperties;
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedissonClient getRedissonClient() {
        if (this.redissonClient != null) {
            return this.redissonClient;
        }
        Class<ManateeRedissonConfig> clazz = ManateeRedissonConfig.class;
        synchronized (ManateeRedissonConfig.class) {
            if (this.redissonClient != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.redissonClient;
            }
            this.LOGGER.debug("init redissonClient conf");
            Config config = null;
            try {
                URL url = ManateeRedissonConfig.class.getClassLoader().getResource("redission-config.yml");
                if (url != null) {
                    config = Config.fromYAML((URL)url);
                } else if (StrUtil.isNotBlank((CharSequence)this.hostInSpringRedis)) {
                    config = new Config();
                    config.useSingleServer().setAddress("redis://" + this.hostInSpringRedis + ":" + this.portInSpringRedis);
                    if (StringUtil.isNotBlank((String)this.passwordInSpringRedis)) {
                        config.useSingleServer().setPassword(this.passwordInSpringRedis);
                    }
                } else if (this.redisClusterProperties != null && CollUtil.isNotEmpty(this.redisClusterProperties.getNodes())) {
                    config = new Config();
                    ClusterServersConfig clusterServersConfig = config.useClusterServers();
                    for (String node : this.redisClusterProperties.getNodes()) {
                        clusterServersConfig.addNodeAddress(new String[]{"redis://" + node});
                    }
                    if (StringUtil.isNotBlank((String)this.passwordInSpringRedis)) {
                        clusterServersConfig.setPassword(this.passwordInSpringRedis);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.redissonClient = Redisson.create((Config)config);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.redissonClient;
        }
    }

    public void onApplicationEvent(ContextStartedEvent contextStartedEvent) {
        RedissonClient bean = (RedissonClient)SpringContextManager.getBean(RedissonClient.class);
        this.LOGGER.debug("get coustmer dubbo conf");
        this.redissonClient = bean;
    }
}

