/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.swagger.manager;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.manatee.common.util.tool.core.util.ReflectUtil;
import com.manatee.swagger.constant.SwaggerConstant;
import com.manatee.swagger.manager.SwaggerManager;
import com.manatee.swagger.plugin.SwaggerDemoResponse;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.DocumentationPluginsBootstrapper;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;

@Component
public class SwaggerInit {
    @Resource
    private ApplicationContext applicationContext;
    @Value(value="${manatee.swagger.group-name:default}")
    private String groupName;
    @Resource
    private SwaggerManager swaggerManager;

    @PostConstruct
    private void init() {
        this.initSwaggerContext((ConfigurableApplicationContext)this.applicationContext);
        this.swaggerManager.initSwagger();
    }

    private void initSwaggerContext(ConfigurableApplicationContext applicationContext) {
        SwaggerConstant.DEFAULT_GROUP = this.groupName;
        try {
            DocumentationPluginsBootstrapper bootstrapper = (DocumentationPluginsBootstrapper)applicationContext.getBeanFactory().getBean(DocumentationPluginsBootstrapper.class);
            Field field1 = bootstrapper.getClass().getDeclaredField("documentationPluginsManager");
            field1.setAccessible(true);
            DocumentationPluginsManager documentationPluginsManager = (DocumentationPluginsManager)field1.get(bootstrapper);
            Field field2 = documentationPluginsManager.getClass().getDeclaredField("documentationPlugins");
            field2.setAccessible(true);
            PluginRegistry pluginRegistrys = (PluginRegistry)field2.get(documentationPluginsManager);
            List dockets = pluginRegistrys.getPlugins();
            Field unModList = ReflectUtil.getField(dockets.getClass(), (String)"list");
            unModList.setAccessible(true);
            List groupList = (List)unModList.get(dockets);
            for (DocumentationPlugin plugin : groupList) {
                if (!plugin.getGroupName().equals(this.groupName)) continue;
                if (plugin instanceof Docket) {
                    Docket docket = (Docket)plugin;
                    docket.additionalModels(new TypeResolver().resolve(SwaggerDemoResponse.class, new Type[0]), new ResolvedType[0]);
                }
                return;
            }
            groupList.add(this.createManateeDocket());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Docket createManateeDocket() {
        String basePackage = "com.manatee.swagger.demo";
        ArrayList<ResponseMessage> responseMessageList = new ArrayList<ResponseMessage>();
        responseMessageList.add(new ResponseMessageBuilder().code(200).message("\u6210\u529f").responseModel((ModelReference)new ModelRef("Payload")).build());
        Docket manateeDocket = new Docket(DocumentationType.SWAGGER_2).groupName(this.groupName).apiInfo(this.manateeApiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).build();
        manateeDocket.additionalModels(new TypeResolver().resolve(SwaggerDemoResponse.class, new Type[0]), new ResolvedType[0]);
        return manateeDocket;
    }

    private ApiInfo manateeApiInfo() {
        return new ApiInfoBuilder().title("\u5c0f\u6d77\u725b\u6587\u6863").contact(new Contact("manatee", "http://doc.manateeai.com", "")).version("1.0").description("api\u7ba1\u7406").build();
    }
}

