/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.PageResult;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.handler.HandleHelper;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.lowcodedb.process.CascadeQueryUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManateeQueryProcess
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeQueryProcess.class);
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private CascadeQueryUtil cascadeQueryUtil;
    @Resource
    private TenantManager tenantManager;

    public void process(ProcessContent content) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
        String dataBaseName = this.variableUtil.calVarInConf(content, "schema");
        if (StringUtil.isBlank((String)dataBaseName)) {
            dataBaseName = dataSource.getDataBaseName();
        }
        DBQuery query = new DBQuery();
        query.setDb(dataBaseName);
        DbEntity dbEntity = this.createDbEntity(content, dataBaseName, query);
        Object camelCaseData = content.getStepConf().get((Object)"camelCase");
        this.dBManager.camelCase(camelCaseData, query);
        String upperOrLowerCaseData = content.getStepConf().getString("upperOrLowerCase");
        query.setUpperOrLowerCase(upperOrLowerCaseData);
        this.dBManager.sort(content, query);
        Collection<Order> orders = dbEntity.setSortConditionForDbQuery(query.getTable(), query.getSort());
        DbClient use = DbClient.use(db);
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            List<DbEntity> entities;
            this.dBManager.page(content, query);
            if (query.getPage() != null) {
                Page newPage = this.getNewPage(query.getCamelCase(), upperOrLowerCaseData, query.getPage());
                newPage.setOrder((Order[])ArrayUtil.toArray(orders, Order.class));
                PageResult<DbEntity> pageEntities = use.page(dbEntity, newPage);
                int totalPage = pageEntities.getTotalPage();
                int total = pageEntities.getTotal();
                entities = pageEntities;
                JSONObject totalCountJson = this.getTotalJson(content, totalPage, total);
                if (totalCountJson != null) {
                    this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
                }
            } else {
                entities = use.find(dbEntity, ManateeListHandler.create(query.getCamelCase(), upperOrLowerCaseData), (Order[])ArrayUtil.toArray(orders, Order.class), dbEntity.getJoins());
            }
            if (entities != null && entities.size() > 0 && dbEntity.getJoins() != null && dbEntity.getJoins().size() > 0) {
                for (Join join : dbEntity.getJoins()) {
                    if (!"returnObj".equals(join.getJoinReturnDataType()) || join.getJoinQueryFields() == null || join.getJoinQueryFields().size() <= 0) continue;
                    for (DbEntity entity : entities) {
                        HandleHelper.joinQueryFieldToObject(join, query, entity);
                    }
                }
            }
            this.cascadeQueryUtil.cascadeQuery(entities, use, query, content);
            this.outputUtil.setDefaultReturnKey(content, "outputData");
            if (entities != null) {
                String syntaxType = content.getStepConf().getString("syntaxTypeDataProcess");
                this.outputUtil.handleAndPutDataV2(content, entities, syntaxType);
            }
        }
        catch (SQLException e) {
            this.LOGGER.error("ManateeCountProcess error , db:\u3010{}\u3011", (Object)db);
            throw new BizException((Throwable)e);
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
    }

    private DbEntity createDbEntity(ProcessContent content, String dataBaseName, DBQuery query) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        query.setTable(table);
        String columns = this.variableUtil.calVarInConf(content, "columns");
        String syntaxType = content.getStepConf().getString("syntaxType");
        List<Map> queryListParams = this.dBManager.getQueryListParamsV2(content, syntaxType);
        JSONArray in = this.dBManager.in(content);
        Boolean isFilterNullArray = content.getStepConf().getBoolean("isFilterNullArray");
        this.dBManager.in(in, query, isFilterNullArray);
        this.dBManager.join(content, query);
        this.dBManager.cascade(content, query);
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setQueryColumnsForDbQuery(table, columns).setWhereConditionListForDbQuery(table, queryListParams, content).setInConditionForDbQuery(table, query.getIn());
        Collection<Join> joins = dbEntity.setJoinConditionForDbQuery(query.getJoin(), content, dataBaseName, this.variableUtil);
        dbEntity.setJoins(joins);
        this.tenantManager.addTenantToEntity(content, dbEntity);
        return dbEntity;
    }

    private Page getNewPage(Boolean camelCase, String upperOrLowerCaseData, com.manatee.common.domain.Page page) {
        Integer pageNum = page.getPageNum() - 1;
        Integer pageSize = page.getPageSize();
        return Page.of(pageNum, pageSize, camelCase, upperOrLowerCaseData);
    }

    private JSONObject getTotalJson(ProcessContent content, int totalPage, int total) {
        String selectTotalCount = this.variableUtil.calVarInConf(content, "selectTotalCount");
        if (selectTotalCount == null || "false".equalsIgnoreCase(selectTotalCount)) {
            return null;
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        totalCountJson.put(totalPageReturnKey, (Object)totalPage);
        totalCountJson.put(totalCountReturnKey, (Object)total);
        return totalCountJson;
    }

    public String getName() {
        return "manateeQueryProcess";
    }
}

