/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.GlobalDbConfig;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.ConditionGroup;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.domain.ProcessContent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Wrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected GlobalDbConfig globalDbConfig = (GlobalDbConfig)SpringContextManager.getBean(GlobalDbConfig.class);
    private Character preWrapQuote;
    private Character sufWrapQuote;

    public Wrapper() {
    }

    public Wrapper(Character wrapQuote) {
        this.preWrapQuote = wrapQuote;
        this.sufWrapQuote = wrapQuote;
    }

    public Wrapper(Character preWrapQuote, Character sufWrapQuote) {
        this.preWrapQuote = preWrapQuote;
        this.sufWrapQuote = sufWrapQuote;
    }

    public char getPreWrapQuote() {
        return this.preWrapQuote.charValue();
    }

    public void setPreWrapQuote(Character preWrapQuote) {
        this.preWrapQuote = preWrapQuote;
    }

    public char getSufWrapQuote() {
        return this.sufWrapQuote.charValue();
    }

    public void setSufWrapQuote(Character sufWrapQuote) {
        this.sufWrapQuote = sufWrapQuote;
    }

    public String wrapTable(String tableName) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank((CharSequence)tableName)) {
            return tableName;
        }
        if (StrUtil.isSurround((CharSequence)tableName, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue())) {
            return tableName;
        }
        if (tableName.contains(".")) {
            Collection<String> target = this.getTableTarget(tableName);
            return CollectionUtil.join(target, (CharSequence)".");
        }
        ProcessContent processContent = ThreadLocalConnection.INSTANCE.getProcessContent();
        if (processContent != null && processContent.getProjectId() == 0L) {
            if (StringUtils.equals((CharSequence)tableName, (CharSequence)"lowcode_base_module") || StringUtils.equals((CharSequence)tableName, (CharSequence)"lowcode_project_conf")) {
                return StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, tableName, this.sufWrapQuote});
            }
            return tableName;
        }
        if (this.globalDbConfig.isTableNameCaseInsensitive()) {
            return StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, tableName, this.sufWrapQuote});
        }
        return tableName;
    }

    public String wrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank((CharSequence)field)) {
            return field;
        }
        if (StrUtil.isSurround((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue())) {
            return field;
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)field, (CharSequence[])new CharSequence[]{"*", "("})) {
            if (field.contains(".*")) {
                Collection<String> target = this.getFieldTarget(field);
                return CollectionUtil.join(target, (CharSequence)".");
            }
            return field;
        }
        if (StrUtil.contains((CharSequence)field, (CharSequence)" as ")) {
            Collection<String> target = this.getAsTarget(field, " as ");
            return CollectionUtil.join(target, (CharSequence)".");
        }
        if (StrUtil.contains((CharSequence)field, (CharSequence)" AS ")) {
            Collection<String> target = this.getAsTarget(field, " AS ");
            return CollectionUtil.join(target, (CharSequence)".");
        }
        if (field.contains(".")) {
            Collection<String> target = this.getFieldTarget(field);
            return CollectionUtil.join(target, (CharSequence)".");
        }
        ProcessContent processContent = ThreadLocalConnection.INSTANCE.getProcessContent();
        if (processContent != null && processContent.getProjectId() == 0L) {
            if (StringUtils.equals((CharSequence)field, (CharSequence)"lowcode_base_module") || StringUtils.equals((CharSequence)field, (CharSequence)"lowcode_project_conf")) {
                return StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, field, this.sufWrapQuote});
            }
            return field;
        }
        if (!this.globalDbConfig.isFieldNameCaseInsensitive()) {
            return field;
        }
        return StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, field, this.sufWrapQuote});
    }

    private Collection<String> getTableTarget(String tableName) {
        String format;
        List split = StrUtil.split((CharSequence)tableName, (char)'.', (int)2);
        ArrayList<String> target = new ArrayList<String>(split.size());
        ProcessContent processContent = ThreadLocalConnection.INSTANCE.getProcessContent();
        if (this.globalDbConfig.isDbNameCaseInsensitive()) {
            format = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, split.get(0), this.sufWrapQuote});
            target.add(format);
        } else {
            target.add((String)split.get(0));
        }
        if (processContent != null && processContent.getProjectId() == 0L) {
            String tableNameTemp = (String)split.get(1);
            if (StringUtils.equals((CharSequence)tableNameTemp, (CharSequence)"lowcode_base_module") || StringUtils.equals((CharSequence)tableNameTemp, (CharSequence)"lowcode_project_conf")) {
                tableNameTemp = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, tableNameTemp, this.sufWrapQuote});
            }
            target.add(tableNameTemp);
        } else if (this.globalDbConfig.isTableNameCaseInsensitive()) {
            format = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, split.get(1), this.sufWrapQuote});
            target.add(format);
        } else {
            target.add((String)split.get(1));
        }
        return target;
    }

    private Collection<String> getFieldTarget(String field) {
        String format;
        List split = StrUtil.split((CharSequence)field, (char)'.', (int)2);
        ArrayList<String> target = new ArrayList<String>(split.size());
        ProcessContent processContent = ThreadLocalConnection.INSTANCE.getProcessContent();
        if (processContent != null && processContent.getProjectId() == 0L) {
            String tableNameTemp = (String)split.get(0);
            if (StringUtils.equals((CharSequence)tableNameTemp, (CharSequence)"lowcode_base_module") || StringUtils.equals((CharSequence)tableNameTemp, (CharSequence)"lowcode_project_conf")) {
                tableNameTemp = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, tableNameTemp, this.sufWrapQuote});
            }
            target.add(tableNameTemp);
        } else if (this.globalDbConfig.isTableNameCaseInsensitive()) {
            format = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, split.get(0), this.sufWrapQuote});
            target.add(format);
        } else {
            target.add((String)split.get(0));
        }
        if (processContent != null && processContent.getProjectId() == 0L) {
            target.add((String)split.get(1));
        } else if (this.globalDbConfig.isFieldNameCaseInsensitive() && !"*".equals(split.get(1))) {
            format = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, split.get(1), this.sufWrapQuote});
            target.add(format);
        } else {
            target.add((String)split.get(1));
        }
        return target;
    }

    private Collection<String> getAsTarget(String field, String separator) {
        String format;
        String[] split = StrUtil.split((CharSequence)field, (CharSequence)separator);
        ArrayList<String> target = new ArrayList<String>(split.length);
        if (!split[0].contains(".")) {
            ProcessContent processContent = ThreadLocalConnection.INSTANCE.getProcessContent();
            if (processContent != null && processContent.getProjectId() == 0L) {
                target.add(field);
            } else if (this.globalDbConfig.isFieldNameCaseInsensitive()) {
                String format2 = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, split[0], this.sufWrapQuote});
                target.add(format2 + separator + split[1]);
            } else {
                target.add(field);
            }
            return target;
        }
        String[] dataTableNameAndfiledName = StrUtil.split((CharSequence)split[0], (CharSequence)".");
        ProcessContent processContent = ThreadLocalConnection.INSTANCE.getProcessContent();
        if (processContent != null && processContent.getProjectId() == 0L) {
            String tableNameTemp = dataTableNameAndfiledName[0];
            if (StringUtils.equals((CharSequence)tableNameTemp, (CharSequence)"lowcode_base_module") || StringUtils.equals((CharSequence)tableNameTemp, (CharSequence)"lowcode_project_conf")) {
                tableNameTemp = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, tableNameTemp, this.sufWrapQuote});
            }
            target.add(tableNameTemp);
        } else if (this.globalDbConfig.isTableNameCaseInsensitive()) {
            format = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, dataTableNameAndfiledName[0], this.sufWrapQuote});
            target.add(format);
        } else {
            target.add(dataTableNameAndfiledName[0]);
        }
        if (processContent != null && processContent.getProjectId() == 0L) {
            target.add(dataTableNameAndfiledName[1] + separator + split[1]);
        } else if (this.globalDbConfig.isFieldNameCaseInsensitive()) {
            format = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.preWrapQuote, dataTableNameAndfiledName[1], this.sufWrapQuote});
            target.add(format + separator + split[1]);
        } else {
            target.add(dataTableNameAndfiledName[1] + separator + split[1]);
        }
        return target;
    }

    public String[] wrapTable(String ... tables) {
        if (ArrayUtil.isEmpty((Object[])tables)) {
            return tables;
        }
        String[] wrappedTables = new String[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            wrappedTables[i] = this.wrapTable(tables[i]);
        }
        return wrappedTables;
    }

    public String[] wrap(String ... fields) {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[0])));
    }

    public DbEntity wrap(DbEntity entity) {
        if (null == entity) {
            return null;
        }
        DbEntity wrapedEntity = new DbEntity();
        wrapedEntity.setTableName(this.wrap(entity.getTableName()));
        for (Map.Entry entry : entity.entrySet()) {
            wrapedEntity.set(this.wrap((String)entry.getKey()), entry.getValue());
        }
        return wrapedEntity;
    }

    public Condition[] wrap(Condition ... conditions) {
        if (conditions == null) {
            return null;
        }
        Condition[] clonedConditions = new Condition[conditions.length];
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = (Condition)((Object)conditions[i].clone());
                if (clonedCondition instanceof ConditionGroup) {
                    ConditionGroup conditionGroup = (ConditionGroup)clonedCondition;
                    Condition[] clonedConditionGroup = this.wrap(conditionGroup.getConditions());
                    ConditionGroup conditionGroupNew = new ConditionGroup();
                    conditionGroupNew.addConditions(clonedConditionGroup);
                    conditionGroupNew.setLinkOperator(conditionGroup.getLinkOperator());
                    clonedConditions[i] = conditionGroupNew;
                    continue;
                }
                clonedCondition.setField(this.wrap(clonedCondition.getField()));
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }

    public Condition[] wrap(String tableName, Condition ... conditions) {
        Condition[] clonedConditions = new Condition[conditions.length];
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = (Condition)((Object)conditions[i].clone());
                if (StrUtil.isNotBlank((CharSequence)tableName)) {
                    clonedCondition.setField(tableName + "." + this.wrap(clonedCondition.getField()));
                } else {
                    clonedCondition.setField(this.wrap(clonedCondition.getField()));
                }
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }
}

