/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.GlobalDbConfig;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.dialect.Dialect;
import com.manatee.lowcodedb.newdb.dialect.DialectFactory;
import com.manatee.lowcodedb.newdb.handler.NumberHandler;
import com.manatee.lowcodedb.newdb.handler.RsHandler;
import com.manatee.lowcodedb.newdb.sql.DBQuery;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.SqlExecutor;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public class DialectRunner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Dialect dialect;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;

    public DialectRunner(Dialect dialect) {
        this.dialect = dialect;
    }

    public DialectRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(Connection conn, DbEntity ... records) throws SQLException {
        PreparedStatement ps;
        block4: {
            int[] nArray;
            this.checkConn(conn);
            if (ArrayUtil.isEmpty((Object[])records)) {
                return new int[]{0};
            }
            ps = null;
            try {
                if (1 != records.length) break block4;
                ps = this.dialect.psForInsert(conn, records[0]);
                nArray = new int[]{ps.executeUpdate()};
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return nArray;
        }
        ps = this.dialect.psForInsertBatch(conn, records);
        int[] nArray = ps.executeBatch();
        DbUtil.close(ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upsert(Connection conn, DbEntity record, String ... keys) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.getDialect().psForUpsert(conn, record, keys);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (null != ps) {
            int n;
            try {
                n = ps.executeUpdate();
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return n;
        }
        return this.insertOrUpdate(conn, record, keys);
    }

    public int insertOrUpdate(Connection conn, DbEntity record, String ... keys) throws SQLException {
        DbEntity where = record.filter(keys);
        if (MapUtil.isNotEmpty((Map)((Object)where)) && this.count(conn, where) > 0L) {
            return this.update(conn, record.removeNew(keys), where);
        }
        return this.insert(conn, record)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T insert(Connection conn, DbEntity record, RsHandler<T> generatedKeysHandler) throws SQLException {
        PreparedStatement ps;
        block4: {
            T t;
            this.checkConn(conn);
            if (MapUtil.isEmpty((Map)((Object)record))) {
                throw new SQLException("Empty entity provided!");
            }
            ps = null;
            try {
                ps = this.dialect.psForInsert(conn, record);
                ps.executeUpdate();
                if (null != generatedKeysHandler) break block4;
                t = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return t;
        }
        T t = StatementUtil.getGeneratedKeys(ps, generatedKeysHandler);
        DbUtil.close(ps);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int del(Connection conn, DbEntity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty((Map)((Object)where))) {
            throw new SQLException("\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, DBQuery.of(where));
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, DbEntity record, DbEntity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty((Map)((Object)record))) {
            throw new SQLException("Empty entity provided!");
        }
        if (MapUtil.isEmpty((Map)((Object)where))) {
            throw new SQLException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StrUtil.isBlank((CharSequence)tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        DBQuery query = new DBQuery(SqlUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBatch(Connection conn, Collection<Map> recordAndWhereList) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollUtil.isEmpty(recordAndWhereList)) {
            throw new SQLException("Empty entity provided!");
        }
        for (Map map : recordAndWhereList) {
            DbEntity record = (DbEntity)((Object)map.get("record"));
            DbEntity where = (DbEntity)((Object)map.get("where"));
            String tableName = record.getTableName();
            if (StrUtil.isBlank((CharSequence)tableName)) {
                tableName = where.getTableName();
                record.setTableName(tableName);
            }
            DBQuery query = new DBQuery(SqlUtil.buildConditions(where), tableName);
            map.put("query", query);
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdateBatch(conn, recordAndWhereList);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T find(Connection conn, DBQuery query, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        Assert.notNull((Object)query, (String)"[query] is null !", (Object[])new Object[0]);
        return SqlExecutor.queryAndClosePs(this.dialect.psForFind(conn, query), rsh, new Object[0]);
    }

    public long count(Connection conn, DbEntity where) throws SQLException {
        this.checkConn(conn);
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount(conn, DBQuery.of(where).setFields(where.getFieldNames()).setJoins(where.getJoins())), new NumberHandler(), new Object[0]).longValue();
    }

    public long count(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        this.checkConn(conn);
        String selectSql = sqlBuilder.build();
        int orderByIndex = StrUtil.lastIndexOfIgnoreCase((CharSequence)selectSql, (CharSequence)" order by");
        if (orderByIndex > 0) {
            selectSql = StrUtil.subPre((CharSequence)selectSql, (int)orderByIndex);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount(conn, SqlBuilder.of(selectSql).addParams(sqlBuilder.getParamValueArray())), new NumberHandler(), new Object[0]).longValue();
    }

    public <T> T page(Connection conn, DBQuery query, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == query.getPage()) {
            return this.find(conn, query, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, query), rsh, new Object[0]);
    }

    public <T> T page(Connection conn, SqlBuilder sqlBuilder, Page page, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            return SqlExecutor.query(conn, sqlBuilder, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, sqlBuilder, page), rsh, new Object[0]);
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setWrapper(Character wrapperChar) {
        this.setWrapper(new Wrapper(wrapperChar));
    }

    public void setWrapper(Wrapper wrapper) {
        this.dialect.setWrapper(wrapper);
    }

    private void checkConn(Connection conn) {
        Assert.notNull((Object)conn, (String)"Connection object must be not null!", (Object[])new Object[0]);
    }
}

