/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CloneUtil;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.iutil.IJoinManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.mongo.MongoReadUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MongoQueryProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private MongoReadUtil mongoReadUtil;
    @Resource
    private IJoinManager joinManager;
    @Resource
    private IDBManager dBManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "mongo");
        DBQuery dbQueryForCount = (DBQuery)CloneUtil.cloneByStream((Object)dbQuery);
        JSONObject totalCountJson = this.mongoReadUtil.queryTotalCount(content, dbQueryForCount);
        JSON data = this.queryData(content, dbQuery);
        this.outputUtil.handleAndPutData(content, (Object)data);
        this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
    }

    public JSON queryData(ProcessContent content, DBQuery dbQuery) throws BizException {
        JSON data = this.mongoReadUtil.find(dbQuery);
        this.joinManager.join(content, dbQuery, data);
        return data;
    }

    public String getName() {
        return "mongoQuery";
    }
}

