/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.mongo.MongoClientInit;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Service;

@Service
public class MongoWriteUtil {
    @Resource
    private MongoClientInit mongoClientInit;

    public Object insert(String database, String table, Map<String, Object> map) throws BizException {
        if (map == null || map.size() == 0) {
            return null;
        }
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(database, table);
        Document document = new Document(map);
        mongoCollection.insertOne((Object)document);
        Object id = document.get((Object)"_id");
        return id;
    }

    public void insertList(String database, String table, List<Map<String, Object>> list) throws BizException {
        if (list == null || list.size() == 0) {
            return;
        }
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(database, table);
        ArrayList<Document> docList = new ArrayList<Document>();
        for (Map<String, Object> map : list) {
            Document document = new Document(map);
            docList.add(document);
        }
        mongoCollection.insertMany(docList);
    }

    public void update(String database, String table, Map<String, Object> map) throws BizException {
        if (map.get("id") == null) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "id_is_null");
        }
        String id = (String)map.get("id");
        map.remove("id");
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(database, table);
        Document document = new Document("_id", (Object)new ObjectId(id));
        Document document2 = new Document(map);
        mongoCollection.updateOne((Bson)document, (Bson)new Document("$set", (Object)document2));
    }

    public long update(String database, String table, Map<String, Object> condition, Map<String, Object> map) throws BizException {
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(database, table);
        this.formatObjectIdType(condition);
        Document document = new Document(condition);
        Document document2 = new Document(map);
        return mongoCollection.updateMany((Bson)document, (Bson)new Document("$set", (Object)document2)).getModifiedCount();
    }

    public long delete(String dataBase, String table, Map<String, Object> condition) throws BizException {
        this.formatObjectIdType(condition);
        Document document = new Document(condition);
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(dataBase, table);
        DeleteResult deleteResult = mongoCollection.deleteMany((Bson)document);
        return deleteResult.getDeletedCount();
    }

    private void formatObjectIdType(Map<String, Object> condition) {
        for (Map.Entry<String, Object> map : condition.entrySet()) {
            if (!ObjectId.isValid((String)map.getValue().toString())) continue;
            condition.put(map.getKey(), new ObjectId(map.getValue().toString()));
        }
    }

    private void formatId(Map<String, Object> condition) {
        String id = (String)condition.get("id");
        if (id != null) {
            condition.put("_id", new ObjectId(id));
            condition.remove("id");
        }
    }
}

