CREATE TABLE lowcode_base_module (
    module_id bigint NOT NULL,
    module_code varchar(100) DEFAULT '' NOT NULL,
    module_name varchar(100) DEFAULT '' NOT NULL,
    module_description varchar(255) DEFAULT '' NOT NULL,
    module_version varchar(16) DEFAULT 'v1.0.0' NOT NULL,
    env varchar(16) DEFAULT '' NOT NULL,
    package_id bigint DEFAULT '0' NOT NULL,
    project_id bigint DEFAULT '0' NOT NULL,
    module_type tinyint DEFAULT '1' NOT NULL,
    request_mode varchar(16) DEFAULT 'POST' NOT NULL,
    is_login smallint DEFAULT '0' NOT NULL,
    process_conf text,
    valid smallint DEFAULT '0' NOT NULL,
    gmt_create datetime NOT NULL DEFAULT getdate(),
    gmt_modified datetime NOT NULL DEFAULT getdate(),
    params text,
    mock text,
    chart_url varchar(255) DEFAULT '' NOT NULL,
    interrupt text,
    create_user bigint DEFAULT '0' NOT NULL,
    modified_user bigint DEFAULT '0' NOT NULL,
    system_version varchar(16) DEFAULT '' NOT NULL,
    conf text,
    sort int DEFAULT '1' NOT NULL,
    CONSTRAINT valid_projectId_code_version unique (valid, project_id, module_code, module_version),
    CONSTRAINT idx_module_id unique (module_id)
)