CREATE TABLE `lowcode_logic_behavior_params` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `logic_id` bigint(20) NOT NULL COMMENT '逻辑模型id',
  `behavior_id` bigint(20) NOT NULL COMMENT '逻辑模型行为id',
  `param_class` tinyint(4) DEFAULT '0' COMMENT '类型,1-入参，2-出参',
  `param_code` varchar(64) NOT NULL COMMENT '编码',
  `param_type` varchar(64) NOT NULL COMMENT '参数类型,Integer/String/……',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `create_user` bigint(20) DEFAULT NULL COMMENT '创建人',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `modified_user` bigint(20) DEFAULT NULL COMMENT '修改用户',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  `valid` tinyint(4) DEFAULT 0 COMMENT '状态:-1 删除, 0 正常',
  PRIMARY KEY (`id`),
  KEY `idx_behaviorId_code_type` (`behavior_id`,`param_code`,`param_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据模型-逻辑模型行为参数表';