/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.manager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.elasticsearch.domain.ESDelete;
import com.manatee.elasticsearch.domain.ESGroup;
import com.manatee.elasticsearch.domain.ESInsert;
import com.manatee.elasticsearch.domain.ESQuery;
import com.manatee.elasticsearch.domain.ESUpdate;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service
public class ESManager {
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    RestHighLevelClient restHighLevelClient;

    public ESQuery getESQuery(ProcessContent content) throws BizException {
        String groupName;
        Object selectTotalCountObject;
        Object selectOneObject;
        String timeout;
        Map sort;
        ESQuery esQuery = new ESQuery();
        String index = this.variableUtil.calVarInConf(content, "index");
        String type = this.variableUtil.calVarInConf(content, "type");
        if (StringUtil.isNotBlank((String)type)) {
            esQuery.setType(type);
        }
        esQuery.setIndex(index);
        JSONObject indexInfo = this.getIndexInfo(index);
        esQuery.setIndexInfo(indexInfo);
        JSONArray multiQuery = content.getStepConf().getJSONArray("multiQuery");
        for (Object object : multiQuery) {
            JSONObject query = (JSONObject)object;
            Object queryParamsObj = query.get((Object)"queryParams");
            Map queryParams = this.inputUtil.getHandleMapConf(content, queryParamsObj);
            query.put("queryParams", (Object)queryParams);
        }
        esQuery.setMultiQuery(multiQuery);
        Map queryParams = this.inputUtil.getHandleObject(content, "queryParams");
        esQuery.setQueryParams(queryParams);
        String keyword = this.variableUtil.calVarInConf(content, "keyword");
        Boolean isKeyword = Boolean.parseBoolean(keyword);
        esQuery.setIsKeyword(isKeyword);
        String pageNumStr = this.variableUtil.calVarInConf(content, "pageNum");
        String pageSizeStr = this.variableUtil.calVarInConf(content, "pageSize");
        if (StringUtil.isNotBlank((String)pageNumStr)) {
            Integer pageNum = Integer.valueOf(NumberUtil.isNumber((CharSequence)pageNumStr) ? pageNumStr : content.getValue(pageNumStr).toString());
            esQuery.setPageNum(pageNum);
        }
        if (StringUtil.isNotBlank((String)pageSizeStr)) {
            Integer pageSize = Integer.valueOf(NumberUtil.isNumber((CharSequence)pageSizeStr) ? pageSizeStr : content.getValue(pageSizeStr).toString());
            esQuery.setPageSize(pageSize);
        }
        if ((sort = this.inputUtil.getHandleObject(content, "sort")) != null && sort instanceof Map) {
            esQuery.setSort(sort);
        }
        if (NumberUtil.isNumber((CharSequence)(timeout = this.variableUtil.calVarInConf(content, "timeout")))) {
            esQuery.setTimeout(Integer.valueOf(timeout));
        }
        String includes = content.getStepConf().getString("includes");
        String excludes = content.getStepConf().getString("excludes");
        esQuery.setIncludes(includes);
        esQuery.setExcludes(excludes);
        Object camelCaseData = content.getStepConf().get((Object)"camelCase");
        if (camelCaseData != null) {
            Boolean camelCase = Boolean.valueOf(camelCaseData.toString());
            esQuery.setCamelCase(camelCase);
        }
        if ((selectOneObject = content.getStepConf().get((Object)"selectOne")) != null) {
            Boolean selectOne = Boolean.valueOf(selectOneObject.toString());
            esQuery.setSelectOne(selectOne);
        }
        if ((selectTotalCountObject = content.getStepConf().get((Object)"selectTotalCount")) != null) {
            Boolean selectTotalCount = Boolean.valueOf(selectTotalCountObject.toString());
            esQuery.setSelectTotalCount(selectTotalCount);
        }
        if (StringUtil.isNotBlank((String)(groupName = this.variableUtil.calVarInConf(content, "groupName")))) {
            ESGroup group = new ESGroup();
            String groupField = this.variableUtil.calVarInConf(content, "groupField");
            String groupSize = this.variableUtil.calVarInConf(content, "groupSize");
            group.setName(groupName);
            group.setField(groupField);
            group.setSize(StringUtil.isNotBlank((String)groupSize) ? Integer.valueOf(groupSize) : 10);
            esQuery.setGroup(group);
            String subGroupName = this.variableUtil.calVarInConf(content, "subGroupName");
            if (StringUtil.isNotBlank((String)subGroupName)) {
                ESGroup subGroup = new ESGroup();
                subGroup.setName(subGroupName);
                String subGroupField = this.variableUtil.calVarInConf(content, "subGroupField");
                String subGroupSize = this.variableUtil.calVarInConf(content, "subGroupSize");
                subGroup.setField(subGroupField);
                subGroup.setSize(StringUtil.isNotBlank((String)subGroupSize) ? Integer.valueOf(subGroupSize) : 10);
                esQuery.setSubGroup(subGroup);
            }
        }
        return esQuery;
    }

    public ESInsert getESInsert(ProcessContent content) throws BizException {
        String timeout;
        JSONObject conf = content.getStepConf();
        ESInsert esInsert = new ESInsert();
        String index = this.variableUtil.calVarInConf(content, "index");
        esInsert.setIndex(index);
        String handleType = content.getStepConfString("handleType");
        Map insertParams = this.inputUtil.getHandleObject(content, "insertParams");
        if (insertParams == null || insertParams.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "insert_data_is_null");
        }
        esInsert.setInsertColumns(insertParams);
        if ("batch".equals(handleType)) {
            if (!conf.containsKey((Object)"paramsKey")) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "paramsKey_is_null");
            }
            Object insertParamsObject = this.inputUtil.getHandleData(content, "insertParams");
            esInsert.setBatch(true);
            esInsert.setInsertColumnsBatch((List)insertParamsObject);
        }
        if (NumberUtil.isNumber((CharSequence)(timeout = this.variableUtil.calVarInConf(content, "timeout")))) {
            esInsert.setTimeout(Integer.valueOf(timeout));
        }
        return esInsert;
    }

    public ESUpdate getESUpdate(ProcessContent content) throws BizException {
        ESUpdate esUpdate = new ESUpdate();
        String index = this.variableUtil.calVarInConf(content, "index");
        esUpdate.setIndex(index);
        String id = this.variableUtil.calVarInConf(content, "id");
        if (StringUtil.isBlank((String)id)) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "id_is_null");
        }
        esUpdate.setId(id);
        Map updateParams = this.inputUtil.getHandleObject(content, "updateParams");
        if (updateParams == null || updateParams.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "update_data_is_null");
        }
        esUpdate.setUpdateColumns(updateParams);
        return esUpdate;
    }

    public ESDelete getESDelete(ProcessContent content) throws BizException {
        ESDelete esDelete = new ESDelete();
        String index = this.variableUtil.calVarInConf(content, "index");
        esDelete.setIndex(index);
        Object deleteOneData = content.getStepConf().get((Object)"deleteOne");
        if (deleteOneData != null) {
            Boolean deleteOne = Boolean.valueOf(deleteOneData.toString());
            esDelete.setDeleteOne(deleteOne);
        }
        if (esDelete.getDeleteOne().booleanValue()) {
            String id = this.variableUtil.calVarInConf(content, "id");
            if (StringUtil.isBlank((String)id)) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "id_is_null");
            }
            esDelete.setId(id);
        } else {
            String idListKey = content.getStepConfString("idList");
            Object idList = content.getValue(idListKey);
            if (idList == null) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "idList_is_null");
            }
            esDelete.setIdList((List)idList);
        }
        return esDelete;
    }

    public SearchRequest getSearchRequest(ESQuery esQuery) throws BizException {
        Map<String, Object> sort;
        String[] excludes;
        SearchRequest searchRequest = new SearchRequest(new String[]{esQuery.getIndex()});
        if (esQuery.getType() != null) {
            searchRequest.types(new String[]{esQuery.getType()});
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        JSONArray multiQuery = esQuery.getMultiQuery();
        for (int i = 0; i < multiQuery.size(); ++i) {
            Object val;
            JSONObject query = multiQuery.getJSONObject(i);
            String queryType = query.getString("queryType");
            JSONObject queryParams = query.getJSONObject("queryParams");
            if (!CollectionUtil.isNotEmpty((Map)queryParams)) continue;
            if ("termQuery_keyword".equals(queryType)) {
                for (String key : queryParams.keySet()) {
                    val = queryParams.get((Object)key);
                    if (val == null) continue;
                    if ("id".equals(key)) {
                        boolQueryBuilder.must((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{val.toString()}));
                        continue;
                    }
                    if (this.fieldIsKeyword(key, esQuery.getIndexInfo()).booleanValue()) {
                        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)(key + "." + "keyword"), (Object)val));
                        continue;
                    }
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)val));
                }
                continue;
            }
            if ("boolQuery_filter_matchQuery".equals(queryType)) {
                for (String key : queryParams.keySet()) {
                    String valAfterReplace;
                    val = queryParams.get((Object)key);
                    if (val == null || "**".equals(valAfterReplace = val.toString().replace(" ", "")) || "*".equals(valAfterReplace)) continue;
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)key, (String)val.toString()));
                }
                continue;
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        if (esQuery.getPageNum() != null) {
            searchSourceBuilder.from((esQuery.getPageNum() - 1) * esQuery.getPageSize());
        }
        if (esQuery.getIsAggregation().booleanValue()) {
            searchSourceBuilder.size(0);
        } else {
            searchSourceBuilder.size(esQuery.getPageSize().intValue());
        }
        if (esQuery.getIncludes() != null || esQuery.getExcludes() != null) {
            String[] includes = esQuery.getIncludes() != null ? esQuery.getIncludes().split(",") : new String[]{};
            excludes = esQuery.getExcludes() != null ? esQuery.getExcludes().split(",") : new String[]{};
            searchSourceBuilder.fetchSource(includes, excludes);
        }
        if ((sort = esQuery.getSort()) != null) {
            excludes = sort.keySet().iterator();
            while (excludes.hasNext()) {
                String key;
                String sortKey = key = (String)excludes.next();
                if (this.fieldIsKeyword(key, esQuery.getIndexInfo()).booleanValue()) {
                    sortKey = key + "." + "keyword";
                }
                if (SortOrder.ASC.toString().equals(sort.get(key))) {
                    searchSourceBuilder.sort(new FieldSortBuilder(sortKey).order(SortOrder.ASC));
                    continue;
                }
                searchSourceBuilder.sort(new FieldSortBuilder(sortKey).order(SortOrder.DESC));
            }
        }
        Integer timeOut = esQuery.getTimeout();
        searchSourceBuilder.timeout(new TimeValue((long)timeOut.intValue(), TimeUnit.SECONDS));
        ESGroup group = esQuery.getGroup();
        if (group != null) {
            String groupField = this.fieldIsKeyword(group.getField(), esQuery.getIndexInfo()) != false ? group.getField() + "." + "keyword" : group.getField();
            TermsAggregationBuilder groupAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)group.getName()).field(groupField)).size(group.getSize().intValue());
            ESGroup subGroup = esQuery.getSubGroup();
            if (subGroup != null) {
                String subGroupField = this.fieldIsKeyword(subGroup.getField(), esQuery.getIndexInfo()) != false ? subGroup.getField() + "." + "keyword" : subGroup.getField();
                TermsAggregationBuilder subGroupAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)subGroup.getName()).field(subGroupField)).size(subGroup.getSize().intValue());
                groupAgg.subAggregation((AggregationBuilder)subGroupAgg);
            }
            searchSourceBuilder.aggregation((AggregationBuilder)groupAgg);
        }
        String requestJson = searchSourceBuilder.toString();
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    public SearchResponse getSearchResponse(SearchRequest searchRequest) throws BizException {
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            return searchResponse;
        }
        catch (IOException e) {
            BizException bizException = new BizException((Throwable)e);
            bizException.setMsg(e.getMessage());
            throw bizException;
        }
    }

    public JSONObject getIndexInfo(String index) throws BizException {
        GetIndexResponse getIndexResponse;
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        try {
            getIndexResponse = this.restHighLevelClient.indices().get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            BizException bizException = new BizException((Throwable)e);
            bizException.setMsg(e.getMessage());
            throw bizException;
        }
        MappingMetadata mappingMetadata = (MappingMetadata)getIndexResponse.getMappings().get(index);
        if (mappingMetadata == null) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "index\u672a\u627e\u5230");
        }
        Map sourceAsMap = mappingMetadata.getSourceAsMap();
        return new JSONObject((Map)sourceAsMap.get("properties"));
    }

    private Boolean fieldIsKeyword(String field, JSONObject indexInfo) throws BizException {
        if (indexInfo == null) {
            return false;
        }
        JSONObject fieldJson = indexInfo.getJSONObject(field);
        if (fieldJson == null) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "No mapping found for [" + field + "]");
        }
        String type = fieldJson.getString("type");
        if ("text".equals(type)) {
            JSONObject fields = fieldJson.getJSONObject("fields");
            if (fields == null) {
                return false;
            }
            JSONObject keyword = fields.getJSONObject("keyword");
            if (keyword == null) {
                return false;
            }
            String keywordType = keyword.getString("type");
            if ("keyword".equals(keywordType)) {
                return true;
            }
        }
        return false;
    }
}

