/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.util;

import com.manatee.common.util.StringUtil;
import com.manatee.redis.config.RedisClusterProperties;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

@Component
public class RedisClusterClientInit {
    private static volatile JedisCluster readPool = null;
    private static volatile JedisCluster writePool = null;
    @Autowired
    private RedisClusterProperties redisClusterProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JedisCluster getReadPoolInstance() {
        if (null != readPool) return readPool;
        Class<RedisClusterClientInit> clazz = RedisClusterClientInit.class;
        synchronized (RedisClusterClientInit.class) {
            if (null != readPool) return readPool;
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(1000);
            poolConfig.setMaxIdle(8);
            poolConfig.setMaxTotal(50);
            poolConfig.setMaxWaitMillis(100000L);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String url : this.redisClusterProperties.getNodes()) {
                String[] urlArray = StringUtil.split((String)url, (String)":");
                nodes.add(new HostAndPort(urlArray[0], Integer.valueOf(urlArray[1]).intValue()));
            }
            readPool = StringUtils.isBlank((CharSequence)this.redisClusterProperties.getPassword()) ? new JedisCluster(nodes, 10000, 10000, 100, (GenericObjectPoolConfig)poolConfig) : new JedisCluster(nodes, 10000, 10000, 100, this.redisClusterProperties.getPassword(), (GenericObjectPoolConfig)poolConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return readPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JedisCluster getWritePoolInstance() {
        if (null != writePool) return writePool;
        Class<RedisClusterClientInit> clazz = RedisClusterClientInit.class;
        synchronized (RedisClusterClientInit.class) {
            if (null != writePool) return writePool;
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(1000);
            poolConfig.setMaxIdle(8);
            poolConfig.setMaxTotal(50);
            poolConfig.setMaxWaitMillis(100000L);
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String url : this.redisClusterProperties.getNodes()) {
                String[] urlArray = StringUtil.split((String)url, (String)":");
                nodes.add(new HostAndPort(urlArray[0], Integer.valueOf(urlArray[1]).intValue()));
            }
            writePool = StringUtils.isBlank((CharSequence)this.redisClusterProperties.getPassword()) ? new JedisCluster(nodes, 10000, 10000, 100, (GenericObjectPoolConfig)poolConfig) : new JedisCluster(nodes, 10000, 10000, 100, this.redisClusterProperties.getPassword(), (GenericObjectPoolConfig)poolConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return writePool;
        }
    }
}

