/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.source;

import com.manatee.common.exception.BizException;
import com.manatee.redis.constant.RedisModeTypeEnum;
import com.manatee.redis.domain.DtHashDO;
import com.manatee.redis.domain.DtQuery;
import com.manatee.redis.source.IDtSource;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DtSourceManager {
    @Resource
    private IDtSource redisDtSource;
    @Resource
    private IDtSource redisClusterDtSource;
    @Resource
    private IDtSource redisSentinelDtSource;
    @Value(value="${manatee.default.redis.mode:standalone}")
    private String mode;

    public Map<String, Object> query(DtQuery query) throws BizException {
        IDtSource dtSource = this.getDtSource(query);
        return dtSource.query(query);
    }

    public List<Map<String, Object>> batchQuery(DtQuery query) {
        IDtSource dtSource = this.getDtSource(query);
        return dtSource.batchQuery(query);
    }

    public Long incr(DtQuery query) {
        IDtSource dtSource = this.getDtSource(query);
        return dtSource.incr(query);
    }

    public List<String> queryMembers(DtQuery query) throws BizException {
        IDtSource dtSource = this.getDtSource(query);
        return dtSource.queryMembers(query);
    }

    public Boolean addHashToRedis(DtHashDO dtHashDO) {
        IDtSource dtSource = this.getDtSource(dtHashDO);
        long ret = dtSource.insertHash(dtHashDO);
        if (ret > 0L) {
            return true;
        }
        return false;
    }

    public Boolean addMultiFieldHashToRedis(DtHashDO dtHashDO) {
        IDtSource dtSource = this.getDtSource(dtHashDO);
        String ret = dtSource.insertMultiFieldHash(dtHashDO);
        if ("OK".equals(ret)) {
            return true;
        }
        return false;
    }

    public Boolean addStringToRedis(DtHashDO dtHashDO) {
        IDtSource dtSource = this.getDtSource(dtHashDO);
        Integer ret = dtSource.insertValue(dtHashDO);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    private IDtSource getDtSource(DtHashDO dtHashDO) {
        IDtSource dtSource = null;
        if (dtHashDO.getSource() == null) {
            dtSource = RedisModeTypeEnum.CLUSTER.getCode().equals(this.mode) ? this.redisClusterDtSource : (RedisModeTypeEnum.SENTINEL.getCode().equals(this.mode) ? this.redisSentinelDtSource : this.redisDtSource);
        }
        return dtSource;
    }

    public IDtSource getDtSource(DtQuery query) {
        IDtSource dtSource = null;
        if (query.getSource() == null) {
            dtSource = RedisModeTypeEnum.CLUSTER.getCode().equals(this.mode) ? this.redisClusterDtSource : (RedisModeTypeEnum.SENTINEL.getCode().equals(this.mode) ? this.redisSentinelDtSource : this.redisDtSource);
        }
        return dtSource;
    }

    public IDtSource getDtSource() {
        IDtSource dtSource = null;
        dtSource = RedisModeTypeEnum.CLUSTER.getCode().equals(this.mode) ? this.redisClusterDtSource : (RedisModeTypeEnum.SENTINEL.getCode().equals(this.mode) ? this.redisSentinelDtSource : this.redisDtSource);
        return dtSource;
    }
}

